/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class CompositeGenericKey
extends GenericKey {
    private GenericKey[] states;

    CompositeGenericKey(int slots, IndexSpecificSpaceFillingCurveSettingsCache spatialSettings) {
        super(spatialSettings);
        this.states = new GenericKey[slots];
        for (int i = 0; i < slots; ++i) {
            this.states[i] = new GenericKey(spatialSettings);
        }
    }

    @Override
    void writeValue(int stateSlot, Value value2, NativeIndexKey.Inclusion inclusion) {
        this.stateSlot(stateSlot).writeValue(value2, inclusion);
    }

    @Override
    void assertValidValue(int stateSlot, Value value2) {
        Preconditions.requireBetween(stateSlot, 0, this.numberOfStateSlots());
    }

    @Override
    Value[] asValues() {
        Value[] values2 = new Value[this.numberOfStateSlots()];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = this.stateSlot(i).asValue();
        }
        return values2;
    }

    @Override
    void initValueAsLowest(int stateSlot, ValueGroup valueGroup) {
        this.stateSlot(stateSlot).initValueAsLowest(valueGroup);
    }

    @Override
    void initValueAsHighest(int stateSlot, ValueGroup valueGroup) {
        this.stateSlot(stateSlot).initValueAsHighest(valueGroup);
    }

    @Override
    int compareValueToInternal(GenericKey other2) {
        int slots = this.numberOfStateSlots();
        for (int i = 0; i < slots; ++i) {
            int comparison = this.stateSlot(i).compareValueToInternal(other2.stateSlot(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    @Override
    void copyFromInternal(GenericKey key) {
        int slots = this.numberOfStateSlots();
        if (key.numberOfStateSlots() != slots) {
            throw new IllegalArgumentException("Different state lengths " + key.numberOfStateSlots() + " vs " + slots);
        }
        for (int i = 0; i < slots; ++i) {
            this.stateSlot(i).copyFromInternal(key.stateSlot(i));
        }
    }

    @Override
    int sizeInternal() {
        int size2 = 0;
        int slots = this.numberOfStateSlots();
        for (int i = 0; i < slots; ++i) {
            size2 += this.stateSlot(i).sizeInternal();
        }
        return size2;
    }

    @Override
    void putInternal(PageCursor cursor) {
        int slots = this.numberOfStateSlots();
        for (int i = 0; i < slots; ++i) {
            this.stateSlot(i).putInternal(cursor);
        }
    }

    @Override
    boolean getInternal(PageCursor cursor, int keySize) {
        int slots = this.numberOfStateSlots();
        for (int i = 0; i < slots; ++i) {
            if (this.stateSlot(i).getInternal(cursor, keySize)) continue;
            return false;
        }
        return true;
    }

    @Override
    void initializeToDummyValueInternal() {
        int slots = this.numberOfStateSlots();
        for (int i = 0; i < slots; ++i) {
            this.stateSlot(i).initializeToDummyValueInternal();
        }
    }

    @Override
    int numberOfStateSlots() {
        return this.states.length;
    }

    @Override
    public String toStringInternal() {
        StringJoiner joiner = new StringJoiner(",");
        for (GenericKey state : this.states) {
            joiner.add(state.toStringInternal());
        }
        return joiner.toString();
    }

    @Override
    String toDetailedStringInternal() {
        StringJoiner joiner = new StringJoiner(",");
        for (GenericKey state : this.states) {
            joiner.add(state.toDetailedStringInternal());
        }
        return joiner.toString();
    }

    @Override
    void minimalSplitterInternal(GenericKey left2, GenericKey right2, GenericKey into) {
        int i;
        int firstStateToDiffer;
        int compare = 0;
        int stateCount = right2.numberOfStateSlots();
        assert (right2.numberOfStateSlots() == stateCount);
        assert (into.numberOfStateSlots() == stateCount);
        for (firstStateToDiffer = 0; compare == 0 && firstStateToDiffer < stateCount; ++firstStateToDiffer) {
            GenericKey leftState = left2.stateSlot(firstStateToDiffer);
            GenericKey rightState = right2.stateSlot(firstStateToDiffer);
            compare = leftState.compareValueToInternal(rightState);
        }
        --firstStateToDiffer;
        for (i = 0; i < firstStateToDiffer; ++i) {
            into.stateSlot(i).copyFromInternal(right2.stateSlot(i));
        }
        for (i = firstStateToDiffer; i < stateCount; ++i) {
            GenericKey leftState = left2.stateSlot(i);
            GenericKey rightState = right2.stateSlot(i);
            rightState.minimalSplitterInternal(leftState, rightState, into.stateSlot(i));
        }
    }

    @Override
    GenericKey stateSlot(int slot) {
        return this.states[slot];
    }
}

