/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.schema.IndexSample;

class FullScanNonUniqueIndexSampler<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NonUniqueIndexSampler.Adapter {
    private final GBPTree<KEY, VALUE> gbpTree;
    private final IndexLayout<KEY, VALUE> layout;

    FullScanNonUniqueIndexSampler(GBPTree<KEY, VALUE> gbpTree, IndexLayout<KEY, VALUE> layout) {
        this.gbpTree = gbpTree;
        this.layout = layout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexSample result() {
        NativeIndexKey lowest = (NativeIndexKey)this.layout.newKey();
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValuesAsLowest();
        NativeIndexKey highest = (NativeIndexKey)this.layout.newKey();
        highest.initialize(Long.MAX_VALUE);
        highest.initValuesAsHighest();
        NativeIndexKey prev = (NativeIndexKey)this.layout.newKey();
        try (RawCursor seek = this.gbpTree.seek((Object)lowest, (Object)highest);){
            long sampledValues = 0L;
            long uniqueValues = 0L;
            if (seek.next()) {
                prev = (NativeIndexKey)this.layout.copyKey(((Hit)seek.get()).key(), prev);
                ++sampledValues;
                ++uniqueValues;
                while (seek.next()) {
                    Hit hit = (Hit)seek.get();
                    if (this.layout.compareValue(prev, (NativeIndexKey)hit.key()) != 0) {
                        ++uniqueValues;
                        this.layout.copyKey(hit.key(), prev);
                    }
                    ++sampledValues;
                }
            }
            IndexSample indexSample = new IndexSample(sampledValues, uniqueValues, sampledValues);
            return indexSample;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public IndexSample result(int numDocs) {
        throw new UnsupportedOperationException();
    }
}

