/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.index.schema.BlockEntryCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateEntry;

public class IndexUpdateCursor<KEY, VALUE>
implements BlockEntryCursor<KEY, VALUE> {
    private final PageCursor cursor;
    private final Layout<KEY, VALUE> layout;
    private UpdateMode updateMode;
    private final KEY key1;
    private final KEY key2;
    private final VALUE value;

    IndexUpdateCursor(PageCursor cursor, Layout<KEY, VALUE> layout) {
        this.cursor = cursor;
        this.layout = layout;
        this.key1 = layout.newKey();
        this.key2 = layout.newKey();
        this.value = layout.newValue();
    }

    @Override
    public boolean next() throws IOException {
        byte updateModeType = this.cursor.getByte();
        if (updateModeType == -1) {
            return false;
        }
        this.updateMode = UpdateMode.MODES[updateModeType];
        IndexUpdateEntry.read(this.cursor, this.layout, this.updateMode, this.key1, this.key2, this.value);
        return true;
    }

    @Override
    public KEY key() {
        return this.key1;
    }

    @Override
    public VALUE value() {
        return this.value;
    }

    public KEY key2() {
        return this.key2;
    }

    public UpdateMode updateMode() {
        return this.updateMode;
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }
}

