/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

public class NativeAllEntriesReader<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements BoundedIterable<Long> {
    private final GBPTree<KEY, VALUE> tree;
    private final Layout<KEY, VALUE> layout;
    private RawCursor<Hit<KEY, VALUE>, IOException> seeker;

    NativeAllEntriesReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout) {
        this.tree = tree;
        this.layout = layout;
    }

    @Override
    public Iterator<Long> iterator() {
        NativeIndexKey from2 = (NativeIndexKey)this.layout.newKey();
        from2.initialize(Long.MIN_VALUE);
        from2.initValuesAsLowest();
        NativeIndexKey to2 = (NativeIndexKey)this.layout.newKey();
        to2.initialize(Long.MAX_VALUE);
        to2.initValuesAsHighest();
        try {
            this.closeSeeker();
            this.seeker = this.tree.seek((Object)from2, (Object)to2);
            return new PrefetchingIterator<Long>(){

                protected Long fetchNextOrNull() {
                    try {
                        return NativeAllEntriesReader.this.seeker.next() ? Long.valueOf(((NativeIndexKey)((Hit)NativeAllEntriesReader.this.seeker.get()).key()).getEntityId()) : null;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void closeSeeker() throws IOException {
        if (this.seeker != null) {
            this.seeker.close();
            this.seeker = null;
        }
    }

    @Override
    public void close() throws Exception {
        this.closeSeeker();
    }

    @Override
    public long maxCount() {
        return -1L;
    }
}

