/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ThrowingConflictDetector;
import org.neo4j.values.storable.Value;

class NativeIndexUpdater<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
implements IndexUpdater {
    private final KEY treeKey;
    private final VALUE treeValue;
    private final ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger = new ThrowingConflictDetector(true);
    private Writer<KEY, VALUE> writer;
    private boolean closed = true;

    NativeIndexUpdater(KEY treeKey, VALUE treeValue) {
        this.treeKey = treeKey;
        this.treeValue = treeValue;
    }

    NativeIndexUpdater<KEY, VALUE> initialize(Writer<KEY, VALUE> writer) {
        if (!this.closed) {
            throw new IllegalStateException("Updater still open");
        }
        this.writer = writer;
        this.closed = false;
        return this;
    }

    @Override
    public void process(IndexEntryUpdate<?> update2) throws IndexEntryConflictException {
        this.assertOpen();
        NativeIndexUpdater.processUpdate(this.treeKey, this.treeValue, update2, this.writer, this.conflictDetectingValueMerger);
    }

    @Override
    public void close() {
        this.closed = true;
        IOUtils.closeAllUnchecked((AutoCloseable[])new Writer[]{this.writer});
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processUpdate(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update2, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger) throws IndexEntryConflictException {
        switch (update2.updateMode()) {
            case ADDED: {
                NativeIndexUpdater.processAdd(treeKey, treeValue, update2, writer, conflictDetectingValueMerger);
                break;
            }
            case CHANGED: {
                NativeIndexUpdater.processChange(treeKey, treeValue, update2, writer, conflictDetectingValueMerger);
                break;
            }
            case REMOVED: {
                NativeIndexUpdater.processRemove(treeKey, update2, writer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processRemove(KEY treeKey, IndexEntryUpdate<?> update2, Writer<KEY, VALUE> writer) {
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, update2.getEntityId(), update2.values());
        writer.remove(treeKey);
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processChange(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update2, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger) throws IndexEntryConflictException {
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, update2.getEntityId(), update2.beforeValues());
        writer.remove(treeKey);
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, update2.getEntityId(), update2.values());
        treeValue.from(update2.values());
        conflictDetectingValueMerger.controlConflictDetection(treeKey);
        writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
        conflictDetectingValueMerger.checkConflict(update2.values());
    }

    private static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void processAdd(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update2, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE, Value[]> conflictDetectingValueMerger) throws IndexEntryConflictException {
        NativeIndexUpdater.initializeKeyAndValueFromUpdate(treeKey, treeValue, update2.getEntityId(), update2.values());
        conflictDetectingValueMerger.controlConflictDetection(treeKey);
        writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
        conflictDetectingValueMerger.checkConflict(update2.values());
    }

    static <KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> void initializeKeyAndValueFromUpdate(KEY treeKey, VALUE treeValue, long entityId, Value[] values2) {
        NativeIndexUpdater.initializeKeyFromUpdate(treeKey, entityId, values2);
        treeValue.from(values2);
    }

    static <KEY extends NativeIndexKey<KEY>> void initializeKeyFromUpdate(KEY treeKey, long entityId, Value[] values2) {
        treeKey.initialize(entityId);
        for (int i = 0; i < values2.length; ++i) {
            treeKey.initFromValue(i, values2[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
    }
}

