/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.SpatialIndexCache;
import org.neo4j.kernel.impl.index.schema.SpatialIndexPopulator;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;

public class SpatialIndexPopulatingUpdater
extends SpatialIndexCache<IndexUpdater>
implements IndexUpdater {
    SpatialIndexPopulatingUpdater(SpatialIndexPopulator populator, NodePropertyAccessor nodePropertyAccessor) {
        super(new PartFactory(populator, nodePropertyAccessor));
    }

    @Override
    public void process(IndexEntryUpdate<?> update2) throws IndexEntryConflictException {
        PointValue value2 = (PointValue)update2.values()[0];
        switch (update2.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.select(value2.getCoordinateReferenceSystem())).process(update2);
                break;
            }
            case CHANGED: {
                PointValue fromValue = (PointValue)update2.beforeValues()[0];
                IndexUpdater from2 = (IndexUpdater)this.select(fromValue.getCoordinateReferenceSystem());
                IndexUpdater to2 = (IndexUpdater)this.select(value2.getCoordinateReferenceSystem());
                if (from2 == to2) {
                    from2.process(update2);
                    break;
                }
                from2.process(IndexEntryUpdate.remove(update2.getEntityId(), update2.indexKey(), update2.beforeValues()));
                to2.process(IndexEntryUpdate.add(update2.getEntityId(), update2.indexKey(), update2.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.select(value2.getCoordinateReferenceSystem())).process(update2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IndexEntryConflictException {
        for (IndexUpdater updater : this) {
            updater.close();
        }
    }

    static class PartFactory
    implements SpatialIndexCache.Factory<IndexUpdater> {
        private final SpatialIndexPopulator populator;
        private NodePropertyAccessor nodePropertyAccessor;

        PartFactory(SpatialIndexPopulator populator, NodePropertyAccessor nodePropertyAccessor) {
            this.populator = populator;
            this.nodePropertyAccessor = nodePropertyAccessor;
        }

        @Override
        public IndexUpdater newSpatial(CoordinateReferenceSystem crs) {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(crs)).newPopulatingUpdater(this.nodePropertyAccessor);
        }
    }
}

