/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.TemporalIndexCache;
import org.neo4j.kernel.impl.index.schema.TemporalIndexPopulator;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.ValueGroup;

public class TemporalIndexPopulatingUpdater
extends TemporalIndexCache<IndexUpdater>
implements IndexUpdater {
    TemporalIndexPopulatingUpdater(TemporalIndexPopulator populator, NodePropertyAccessor nodePropertyAccessor) {
        super(new PartFactory(populator, nodePropertyAccessor));
    }

    @Override
    public void process(IndexEntryUpdate<?> update2) throws IndexEntryConflictException {
        switch (update2.updateMode()) {
            case ADDED: {
                ((IndexUpdater)this.select(update2.values()[0].valueGroup())).process(update2);
                break;
            }
            case CHANGED: {
                IndexUpdater from2 = (IndexUpdater)this.select(update2.beforeValues()[0].valueGroup());
                IndexUpdater to2 = (IndexUpdater)this.select(update2.values()[0].valueGroup());
                if (from2 == to2) {
                    from2.process(update2);
                    break;
                }
                from2.process(IndexEntryUpdate.remove(update2.getEntityId(), update2.indexKey(), update2.beforeValues()));
                to2.process(IndexEntryUpdate.add(update2.getEntityId(), update2.indexKey(), update2.values()));
                break;
            }
            case REMOVED: {
                ((IndexUpdater)this.select(update2.values()[0].valueGroup())).process(update2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown update mode");
            }
        }
    }

    @Override
    public void close() throws IndexEntryConflictException {
        for (IndexUpdater part : this) {
            part.close();
        }
    }

    static class PartFactory
    implements TemporalIndexCache.Factory<IndexUpdater> {
        private final TemporalIndexPopulator populator;
        private NodePropertyAccessor nodePropertyAccessor;

        PartFactory(TemporalIndexPopulator populator, NodePropertyAccessor nodePropertyAccessor) {
            this.populator = populator;
            this.nodePropertyAccessor = nodePropertyAccessor;
        }

        @Override
        public IndexUpdater newDate() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.DATE)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newLocalDateTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.LOCAL_DATE_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newZonedDateTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.ZONED_DATE_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newLocalTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.LOCAL_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newZonedTime() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.ZONED_TIME)).newPopulatingUpdater(this.nodePropertyAccessor);
        }

        @Override
        public IndexUpdater newDuration() throws IOException {
            return ((WorkSyncedNativeIndexPopulator)this.populator.select(ValueGroup.DURATION)).newPopulatingUpdater(this.nodePropertyAccessor);
        }
    }
}

