/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.StringIndexKey;
import org.neo4j.kernel.impl.index.schema.StringLayout;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.kernel.impl.index.schema.Types;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

class TextType
extends Type {
    static final long CHAR_TYPE_STATE_MARKER = 2L;
    static final int CHAR_TYPE_LENGTH_MARKER = 32768;

    TextType(byte typeId) {
        super(ValueGroup.TEXT, typeId, Values.of(""), Values.of(""));
    }

    @Override
    int valueSize(GenericKey state) {
        return TextType.textKeySize(state.long0);
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2) {
        to2.long0 = from2.long0;
        to2.long2 = from2.long2;
        to2.long3 = from2.long3;
        TextType.setBytesLength(to2, (int)from2.long0);
        System.arraycopy(from2.byteArray, 0, to2.byteArray, 0, (int)from2.long0);
    }

    @Override
    void minimalSplitter(GenericKey left2, GenericKey right2, GenericKey into) {
        int length2 = 0;
        if (left2.type == Types.TEXT) {
            length2 = StringLayout.minimalLengthFromRightNeededToDifferentiateFromLeft(left2.byteArray, (int)left2.long0, right2.byteArray, (int)right2.long0);
        }
        into.writeUTF8(right2.byteArray, 0, length2);
    }

    @Override
    Value asValue(GenericKey state) {
        if (state.byteArray == null) {
            return Values.NO_VALUE;
        }
        if (TextType.isCharValueType(state.long2)) {
            return Values.charValue(TextType.textAsChar(state.byteArray));
        }
        state.long1 = 1L;
        return Values.utf8Value(state.byteArray, 0, (int)state.long0);
    }

    @Override
    int compareValue(GenericKey left2, GenericKey right2) {
        return TextType.compare(left2.byteArray, left2.long0, left2.long2, left2.long3, right2.byteArray, right2.long0, right2.long2, right2.long3);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        TextType.put(cursor, state.byteArray, state.long0, state.long2);
    }

    @Override
    boolean readValue(PageCursor cursor, int size2, GenericKey into) {
        return TextType.read(cursor, size2, into);
    }

    static int textKeySize(long long0) {
        return 2 + (int)long0;
    }

    static int compare(byte[] this_byteArray, long this_long0, long this_long2, long this_long3, byte[] that_byteArray, long that_long0, long that_long2, long that_long3) {
        if (this_byteArray != that_byteArray) {
            if (TextType.isHighestText(this_long3) || TextType.isHighestText(that_long3)) {
                return Boolean.compare(TextType.isHighestText(this_long3), TextType.isHighestText(that_long3));
            }
            if (this_byteArray == null) {
                return -1;
            }
            if (that_byteArray == null) {
                return 1;
            }
        } else {
            return 0;
        }
        return StringIndexKey.lexicographicalUnsignedByteArrayCompare(this_byteArray, (int)this_long0, that_byteArray, (int)that_long0, TextType.booleanOf(this_long2) | TextType.booleanOf(that_long2));
    }

    static void put(PageCursor cursor, byte[] byteArray, long long0, long long2) {
        short length2 = GenericKey.toNonNegativeShortExact(long0);
        cursor.putShort(TextType.isCharValueType(long2) ? (short)(length2 | 0x8000) : length2);
        cursor.putBytes(byteArray, 0, (int)length2);
    }

    static boolean read(PageCursor cursor, int maxSize, GenericKey into) {
        short rawLength = cursor.getShort();
        boolean isCharType = (rawLength & 0x8000) != 0;
        short bytesLength = (short)(rawLength & 0xFFFF7FFF);
        if (bytesLength < 0 || bytesLength > maxSize) {
            GenericKey.setCursorException(cursor, "non-valid bytes length for text, " + bytesLength);
            return false;
        }
        TextType.setCharType(into, isCharType);
        TextType.setBytesLength(into, bytesLength);
        cursor.getBytes(into.byteArray, 0, (int)bytesLength);
        return true;
    }

    static void setCharType(GenericKey into, boolean isCharType) {
        into.long2 = isCharType ? (into.long2 |= 2L) : (into.long2 &= 0xFFFFFFFFFFFFFFFDL);
    }

    private static boolean isHighestText(long long3) {
        return long3 == 1L;
    }

    static boolean isCharValueType(long long2) {
        return TextType.booleanOf(long2 >> 1);
    }

    void write(GenericKey state, byte[] bytes2, boolean isCharType) {
        state.byteArray = bytes2;
        state.long0 = bytes2.length;
        TextType.setCharType(state, isCharType);
    }

    @Override
    void initializeAsHighest(GenericKey state) {
        super.initializeAsHighest(state);
        state.long3 = 1L;
    }

    static char textAsChar(byte[] byteArray) {
        long codePoint = new UTF8StringValue.CodePointCursor(byteArray, 0).nextCodePoint();
        if ((codePoint & 0xFFFFFFFFFFFF0000L) != 0L) {
            throw new IllegalStateException("Char value seems to be bigger than what a char can hold " + codePoint);
        }
        return (char)codePoint;
    }

    private static void setBytesLength(GenericKey state, int length2) {
        if (TextType.booleanOf(state.long1) || state.byteArray == null || state.byteArray.length < length2) {
            state.long1 = 0L;
            state.byteArray = new byte[length2 + length2 / 2];
        }
        state.long0 = length2;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
        joiner.add("long1=" + state.long1);
        joiner.add("long2=" + state.long2);
        joiner.add("long3=" + state.long3);
        joiner.add("byteArray=" + Arrays.toString(state.byteArray));
    }
}

