/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class IndexSpecificSpaceFillingCurveSettingsCache {
    private final ConfiguredSpaceFillingCurveSettingsCache globalConfigCache;
    private final ConcurrentMap<CoordinateReferenceSystem, SpaceFillingCurveSettings> specificIndexConfigCache = new ConcurrentHashMap<CoordinateReferenceSystem, SpaceFillingCurveSettings>();

    public IndexSpecificSpaceFillingCurveSettingsCache(ConfiguredSpaceFillingCurveSettingsCache globalConfigCache, Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> specificIndexConfigCache) {
        this.globalConfigCache = globalConfigCache;
        this.specificIndexConfigCache.putAll(specificIndexConfigCache);
    }

    public SpaceFillingCurve forCrs(int crsTableId, int crsCodePoint, boolean assignToIndexIfNotYetAssigned) {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.get(crsTableId, crsCodePoint);
        return this.forCrs(crs, assignToIndexIfNotYetAssigned);
    }

    public SpaceFillingCurve forCrs(CoordinateReferenceSystem crs, boolean assignToIndexIfNotYetAssigned) {
        SpaceFillingCurveSettings specificSetting = (SpaceFillingCurveSettings)this.specificIndexConfigCache.get(crs);
        if (specificSetting != null) {
            return specificSetting.curve();
        }
        SpaceFillingCurveSettings configuredSetting = this.globalConfigCache.forCRS(crs);
        if (assignToIndexIfNotYetAssigned) {
            this.specificIndexConfigCache.put(crs, configuredSetting);
        }
        return configuredSetting.curve();
    }

    public void visitIndexSpecificSettings(SettingVisitor visitor) {
        visitor.count(this.specificIndexConfigCache.size());
        this.specificIndexConfigCache.forEach(visitor::visit);
    }

    public static interface SettingVisitor {
        public void count(int var1);

        public void visit(CoordinateReferenceSystem var1, SpaceFillingCurveSettings var2);
    }
}

