/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.util.function.Consumer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.values.storable.CoordinateReferenceSystem;

public class SpaceFillingCurveSettingsWriter
implements Consumer<PageCursor> {
    static final byte VERSION = 0;
    private static final int WORST_CASE_SETTINGS_SIZE = 61;
    private final IndexSpecificSpaceFillingCurveSettingsCache settings;

    public SpaceFillingCurveSettingsWriter(IndexSpecificSpaceFillingCurveSettingsCache settings) {
        this.settings = settings;
    }

    @Override
    public void accept(final PageCursor cursor) {
        cursor.putByte((byte)0);
        this.settings.visitIndexSpecificSettings(new IndexSpecificSpaceFillingCurveSettingsCache.SettingVisitor(){

            @Override
            public void count(int count2) {
                cursor.putInt(count2);
            }

            @Override
            public void visit(CoordinateReferenceSystem crs, SpaceFillingCurveSettings settings) {
                cursor.putByte((byte)this.assertInt("table id", crs.getTable().getTableId(), 255));
                cursor.putInt(crs.getCode());
                cursor.putShort((short)this.assertInt("max levels", settings.maxLevels, 65535));
                cursor.putShort((short)this.assertInt("dimensions", settings.dimensions, 65535));
                double[] min2 = settings.extents.getMin();
                double[] max2 = settings.extents.getMax();
                for (int i = 0; i < settings.dimensions; ++i) {
                    cursor.putLong(Double.doubleToLongBits(min2[i]));
                    cursor.putLong(Double.doubleToLongBits(max2[i]));
                }
            }

            private int assertInt(String name, int value2, int mask) {
                if ((value2 & ~mask) != 0) {
                    throw new IllegalArgumentException("Invalid " + name + " " + value2 + ", max is " + mask);
                }
                return value2;
            }
        });
    }

    public static int maxNumberOfSettings(int pageSize) {
        return (pageSize - 134 - 8) / 61;
    }
}

