/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.config;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;

enum SpatialIndexType {
    SingleSpaceFillingCurve(1){

        @Override
        public void writeHeader(SpaceFillingCurveSettings settings, PageCursor cursor) {
            cursor.putInt(settings.maxLevels);
            cursor.putInt(settings.dimensions);
            double[] min2 = settings.extents.getMin();
            double[] max2 = settings.extents.getMax();
            for (int i = 0; i < settings.dimensions; ++i) {
                cursor.putLong(Double.doubleToLongBits(min2[i]));
                cursor.putLong(Double.doubleToLongBits(max2[i]));
            }
        }

        @Override
        public void readHeader(SpaceFillingCurveSettings.SettingsFromIndexHeader settings, ByteBuffer headerBytes) {
            try {
                settings.maxLevels = headerBytes.getInt();
                settings.dimensions = headerBytes.getInt();
                double[] min2 = new double[settings.dimensions];
                double[] max2 = new double[settings.dimensions];
                for (int i = 0; i < settings.dimensions; ++i) {
                    min2[i] = headerBytes.getDouble();
                    max2[i] = headerBytes.getDouble();
                }
                settings.extents = new Envelope(min2, max2);
            }
            catch (BufferUnderflowException e) {
                settings.markAsFailed("Failed to read settings from GBPTree header: " + e.getMessage());
            }
        }
    };

    int id;

    public abstract void writeHeader(SpaceFillingCurveSettings var1, PageCursor var2);

    public abstract void readHeader(SpaceFillingCurveSettings.SettingsFromIndexHeader var1, ByteBuffer var2);

    private SpatialIndexType(int id2) {
        this.id = id2;
    }

    static SpatialIndexType get(int id2) {
        for (SpatialIndexType type : SpatialIndexType.values()) {
            if (type.id != id2) continue;
            return type;
        }
        return null;
    }
}

