/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.newapi.NodeSchemaMatcher;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class IndexTxStateUpdater {
    private final Read read;
    private final IndexingService indexingService;

    public IndexTxStateUpdater(Read read, IndexingService indexingService) {
        this.read = read;
        this.indexingService = indexingService;
    }

    void onLabelChange(int labelId, int[] existingPropertyKeyIds, NodeCursor node, PropertyCursor propertyCursor, LabelChangeType changeType) {
        assert (this.noSchemaChangedInTx());
        Collection<SchemaDescriptor> indexes = this.indexingService.getRelatedIndexes(new long[]{labelId}, existingPropertyKeyIds, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            block4: for (SchemaDescriptor index : indexes) {
                int[] indexPropertyIds = index.schema().getPropertyIds();
                Value[] values2 = this.getValueTuple(node, propertyCursor, -1, Values.NO_VALUE, indexPropertyIds, (MutableIntObjectMap<Value>)materializedProperties);
                switch (changeType) {
                    case ADDED_LABEL: {
                        this.indexingService.validateBeforeCommit(index.schema(), values2);
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), null, ValueTuple.of(values2));
                        continue block4;
                    }
                    case REMOVED_LABEL: {
                        this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), ValueTuple.of(values2), null);
                        continue block4;
                    }
                }
                throw new IllegalStateException((Object)((Object)changeType) + " is not a supported event");
            }
        }
    }

    private boolean noSchemaChangedInTx() {
        return !this.read.txState().hasChanges() || this.read.txState().hasDataChanges();
    }

    void onPropertyAdd(NodeCursor node, PropertyCursor propertyCursor, long[] labels2, int propertyKeyId, int[] existingPropertyKeyIds, Value value2) {
        assert (this.noSchemaChangedInTx());
        Collection<SchemaDescriptor> indexes = this.indexingService.getRelatedIndexes(labels2, propertyKeyId, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            NodeSchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                Value[] values2 = this.getValueTuple(node, propertyCursor, propertyKeyId, value2, index.schema().getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties);
                this.indexingService.validateBeforeCommit(index.schema(), values2);
                this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), null, ValueTuple.of(values2));
            });
        }
    }

    void onPropertyRemove(NodeCursor node, PropertyCursor propertyCursor, long[] labels2, int propertyKeyId, int[] existingPropertyKeyIds, Value value2) {
        assert (this.noSchemaChangedInTx());
        Collection<SchemaDescriptor> indexes = this.indexingService.getRelatedIndexes(labels2, propertyKeyId, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            NodeSchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                Value[] values2 = this.getValueTuple(node, propertyCursor, propertyKeyId, value2, index.schema().getPropertyIds(), (MutableIntObjectMap<Value>)materializedProperties);
                this.read.txState().indexDoUpdateEntry(index.schema(), node.nodeReference(), ValueTuple.of(values2), null);
            });
        }
    }

    void onPropertyChange(NodeCursor node, PropertyCursor propertyCursor, long[] labels2, int propertyKeyId, int[] existingPropertyKeyIds, Value beforeValue, Value afterValue) {
        assert (this.noSchemaChangedInTx());
        Collection<SchemaDescriptor> indexes = this.indexingService.getRelatedIndexes(labels2, propertyKeyId, EntityType.NODE);
        if (!indexes.isEmpty()) {
            MutableIntObjectMap materializedProperties = IntObjectMaps.mutable.empty();
            NodeSchemaMatcher.onMatchingSchema(indexes.iterator(), propertyKeyId, existingPropertyKeyIds, index -> {
                int[] propertyIds = index.getPropertyIds();
                Value[] valuesAfter = this.getValueTuple(node, propertyCursor, propertyKeyId, afterValue, propertyIds, (MutableIntObjectMap<Value>)materializedProperties);
                Value[] valuesBefore = (Value[])valuesAfter.clone();
                int k = ArrayUtils.indexOf(propertyIds, propertyKeyId);
                valuesBefore[k] = beforeValue;
                this.indexingService.validateBeforeCommit((SchemaDescriptor)index, valuesAfter);
                this.read.txState().indexDoUpdateEntry((SchemaDescriptor)index, node.nodeReference(), ValueTuple.of(valuesBefore), ValueTuple.of(valuesAfter));
            });
        }
    }

    private Value[] getValueTuple(NodeCursor node, PropertyCursor propertyCursor, int changedPropertyKeyId, Value changedValue, int[] indexPropertyIds, MutableIntObjectMap<Value> materializedValues) {
        int k;
        Value[] values2 = new Value[indexPropertyIds.length];
        int missing = 0;
        for (k = 0; k < indexPropertyIds.length; ++k) {
            Value value2 = values2[k] = indexPropertyIds[k] == changedPropertyKeyId ? changedValue : (Value)materializedValues.getIfAbsent(indexPropertyIds[k], (Function0 & Serializable)() -> Values.NO_VALUE);
            if (values2[k] != Values.NO_VALUE) continue;
            ++missing;
        }
        if (missing > 0) {
            node.properties(propertyCursor);
            while (missing > 0 && propertyCursor.next()) {
                k = ArrayUtils.indexOf(indexPropertyIds, propertyCursor.propertyKey());
                if (k < 0 || values2[k] != Values.NO_VALUE) continue;
                int propertyKeyId = indexPropertyIds[k];
                boolean thisIsTheChangedProperty = propertyKeyId == changedPropertyKeyId;
                Value value3 = values2[k] = thisIsTheChangedProperty ? changedValue : propertyCursor.propertyValue();
                if (!thisIsTheChangedProperty) {
                    materializedValues.put(propertyKeyId, (Object)values2[k]);
                }
                --missing;
            }
        }
        return values2;
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

