/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.proc.TypeMappers;

public class OutputMappers {
    private static final OutputMapper VOID_MAPPER = new OutputMapper(new FieldSignature[0], new FieldMapper[0]){

        @Override
        public List<FieldSignature> signature() {
            return ProcedureSignature.VOID;
        }
    };
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final TypeMappers typeMappers;

    public OutputMappers(TypeMappers typeMappers) {
        this.typeMappers = typeMappers;
    }

    public OutputMapper mapper(Method method) throws ProcedureException {
        Class<?> cls = method.getReturnType();
        if (cls == Void.class || cls == Void.TYPE) {
            return VOID_MAPPER;
        }
        if (cls != Stream.class) {
            throw this.invalidReturnType(cls);
        }
        Type genericReturnType = method.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a raw Stream.", new Object[0]);
        }
        ParameterizedType genType = (ParameterizedType)genericReturnType;
        Type recordType = genType.getActualTypeArguments()[0];
        if (recordType instanceof WildcardType) {
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a Stream<?>.", new Object[0]);
        }
        if (recordType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)recordType;
            throw new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define and not a parameterized type such as %s.", new Object[]{type});
        }
        return this.mapper((Class)recordType);
    }

    public OutputMapper mapper(Class<?> userClass) throws ProcedureException {
        this.assertIsValidRecordClass(userClass);
        List<Field> fields = this.instanceFields(userClass);
        FieldSignature[] signature = new FieldSignature[fields.size()];
        FieldMapper[] fieldMappers = new FieldMapper[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field2 = fields.get(i);
            if (!Modifier.isPublic(field2.getModifiers())) {
                throw new ProcedureException((Status)Status.Procedure.TypeError, "Field `%s` in record `%s` cannot be accessed. Please ensure the field is marked as `public`.", new Object[]{field2.getName(), userClass.getSimpleName()});
            }
            try {
                FieldMapper fieldMapper;
                TypeMappers.TypeChecker checker = this.typeMappers.checkerFor(field2.getGenericType());
                MethodHandle getter2 = this.lookup.unreflectGetter(field2);
                fieldMappers[i] = fieldMapper = new FieldMapper(getter2, checker);
                signature[i] = FieldSignature.outputField((String)field2.getName(), (Neo4jTypes.AnyType)checker.type(), (boolean)field2.isAnnotationPresent(Deprecated.class));
                continue;
            }
            catch (ProcedureException e) {
                throw new ProcedureException(e.status(), (Throwable)e, "Field `%s` in record `%s` cannot be converted to a Neo4j type: %s", new Object[]{field2.getName(), userClass.getSimpleName(), e.getMessage()});
            }
            catch (IllegalAccessException e) {
                throw new ProcedureException((Status)Status.Procedure.TypeError, (Throwable)e, "Field `%s` in record `%s` cannot be accessed: %s", new Object[]{field2.getName(), userClass.getSimpleName(), e.getMessage()});
            }
        }
        return new OutputMapper(signature, fieldMappers);
    }

    private void assertIsValidRecordClass(Class<?> userClass) throws ProcedureException {
        if (userClass.isPrimitive() || userClass.isArray() || userClass.getPackage() != null && userClass.getPackage().getName().startsWith("java.")) {
            throw this.invalidReturnType(userClass);
        }
    }

    private ProcedureException invalidReturnType(Class<?> userClass) {
        return new ProcedureException((Status)Status.Procedure.TypeError, "Procedures must return a Stream of records, where a record is a concrete class%nthat you define, with public non-final fields defining the fields in the record.%nIf you''d like your procedure to return `%s`, you could define a record class like:%npublic class Output '{'%n    public %s out;%n'}'%n%nAnd then define your procedure as returning `Stream<Output>`.", new Object[]{userClass.getSimpleName(), userClass.getSimpleName()});
    }

    private List<Field> instanceFields(Class<?> userClass) {
        return Arrays.stream(userClass.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && !f.isSynthetic()).collect(Collectors.toList());
    }

    private static class FieldMapper {
        private final MethodHandle getter;
        private final TypeMappers.TypeChecker checker;

        FieldMapper(MethodHandle getter2, TypeMappers.TypeChecker checker) {
            this.getter = getter2;
            this.checker = checker;
        }

        Object apply(Object record) throws ProcedureException {
            Object invoke = this.getValue(record);
            return this.checker.typeCheck(invoke);
        }

        private Object getValue(Object record) throws ProcedureException {
            try {
                return this.getter.invoke(record);
            }
            catch (Throwable throwable) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Unable to read value from record `%s`: %s", new Object[]{record, throwable.getMessage()});
            }
        }
    }

    public static class OutputMapper {
        private final List<FieldSignature> signature;
        private final FieldMapper[] fieldMappers;

        public OutputMapper(FieldSignature[] signature, FieldMapper[] fieldMappers) {
            this.signature = Arrays.asList(signature);
            this.fieldMappers = fieldMappers;
        }

        public List<FieldSignature> signature() {
            return this.signature;
        }

        public Object[] apply(Object record) throws ProcedureException {
            Object[] output = new Object[this.fieldMappers.length];
            for (int i = 0; i < this.fieldMappers.length; ++i) {
                output[i] = this.fieldMappers[i].apply(record);
            }
            return output;
        }
    }
}

