/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.internal.kernel.api.procs.QualifiedName;

class ProcedureHolder<T> {
    private final Map<QualifiedName, Integer> nameToId = new HashMap<QualifiedName, Integer>();
    private final Map<QualifiedName, Integer> caseInsensitveName2Id = new HashMap<QualifiedName, Integer>();
    private final ArrayList<T> store = new ArrayList();

    ProcedureHolder() {
    }

    T get(QualifiedName name) {
        Integer id2 = this.name2Id(name);
        if (id2 == null) {
            return null;
        }
        return this.store.get(id2);
    }

    T get(int id2) {
        return this.store.get(id2);
    }

    void put(QualifiedName name, T item, boolean caseInsensitive) {
        int id2 = this.store.size();
        this.store.add(item);
        this.nameToId.put(name, id2);
        if (caseInsensitive) {
            this.caseInsensitveName2Id.put(this.toLowerCaseName(name), id2);
        } else {
            this.caseInsensitveName2Id.remove(this.toLowerCaseName(name));
        }
    }

    int idOf(QualifiedName name) {
        Integer id2 = this.name2Id(name);
        if (id2 == null) {
            throw new NoSuchElementException();
        }
        return id2;
    }

    List<T> all() {
        return Collections.unmodifiableList(this.store);
    }

    private Integer name2Id(QualifiedName name) {
        Integer id2 = this.nameToId.get(name);
        if (id2 == null) {
            QualifiedName lowerCaseName = this.toLowerCaseName(name);
            id2 = this.caseInsensitveName2Id.get(lowerCaseName);
        }
        return id2;
    }

    private QualifiedName toLowerCaseName(QualifiedName name) {
        String[] oldNs = name.namespace();
        String[] lowerCaseNamespace = new String[oldNs.length];
        for (int i = 0; i < oldNs.length; ++i) {
            lowerCaseNamespace[i] = oldNs[i].toLowerCase();
        }
        String lowercaseName = name.name().toLowerCase();
        return new QualifiedName(lowerCaseNamespace, lowercaseName);
    }
}

