/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.kernel.impl.proc.ByteArrayConverter;
import org.neo4j.kernel.impl.proc.ListConverter;
import org.neo4j.kernel.impl.proc.MapConverter;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.procedure.Name;
import org.neo4j.values.AnyValue;

public class TypeMappers
extends DefaultValueMapper {
    private final Map<Type, DefaultValueConverter> javaToNeo = new HashMap<Type, DefaultValueConverter>();
    private static final DefaultValueConverter TO_ANY = new DefaultValueConverter(Neo4jTypes.NTAny, Object.class);
    private static final DefaultValueConverter TO_STRING = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTString, String.class, DefaultParameterValue::ntString);
    private static final DefaultValueConverter TO_INTEGER = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTInteger, Long.class, s2 -> DefaultParameterValue.ntInteger((long)Long.parseLong(s2)));
    private static final DefaultValueConverter TO_FLOAT = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTFloat, Double.class, s2 -> DefaultParameterValue.ntFloat((double)Double.parseDouble(s2)));
    private static final DefaultValueConverter TO_NUMBER = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTNumber, Number.class, s2 -> {
        try {
            return DefaultParameterValue.ntInteger((long)Long.parseLong(s2));
        }
        catch (NumberFormatException e) {
            return DefaultParameterValue.ntFloat((double)Double.parseDouble(s2));
        }
    });
    private static final DefaultValueConverter TO_BOOLEAN = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTBoolean, Boolean.class, s2 -> DefaultParameterValue.ntBoolean((boolean)Boolean.parseBoolean(s2)));
    private static final DefaultValueConverter TO_MAP = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTMap, Map.class, new MapConverter());
    private static final DefaultValueConverter TO_LIST = TypeMappers.toList(TO_ANY, Object.class);
    private final DefaultValueConverter TO_BYTEARRAY = new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTByteArray, byte[].class, new ByteArrayConverter());

    public TypeMappers() {
        this(null);
    }

    public TypeMappers(EmbeddedProxySPI proxySPI) {
        super(proxySPI);
        this.registerScalarsAndCollections();
    }

    private void registerScalarsAndCollections() {
        this.registerType(String.class, TO_STRING);
        this.registerType(Long.TYPE, TO_INTEGER);
        this.registerType(Long.class, TO_INTEGER);
        this.registerType(Double.TYPE, TO_FLOAT);
        this.registerType(Double.class, TO_FLOAT);
        this.registerType(Number.class, TO_NUMBER);
        this.registerType(Boolean.TYPE, TO_BOOLEAN);
        this.registerType(Boolean.class, TO_BOOLEAN);
        this.registerType(Map.class, TO_MAP);
        this.registerType(List.class, TO_LIST);
        this.registerType(Object.class, TO_ANY);
        this.registerType(byte[].class, this.TO_BYTEARRAY);
        this.registerType(ZonedDateTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, ZonedDateTime.class));
        this.registerType(LocalDateTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTLocalDateTime, LocalDateTime.class));
        this.registerType(LocalDate.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDate, LocalDate.class));
        this.registerType(OffsetTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTTime, OffsetTime.class));
        this.registerType(LocalTime.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTLocalTime, LocalTime.class));
        this.registerType(TemporalAmount.class, new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTDuration, TemporalAmount.class));
    }

    public Neo4jTypes.AnyType toNeo4jType(Type type) throws ProcedureException {
        return this.converterFor((Type)type).type;
    }

    public TypeChecker checkerFor(Type javaType) throws ProcedureException {
        return this.converterFor(javaType);
    }

    DefaultValueConverter converterFor(Type javaType) throws ProcedureException {
        DefaultValueConverter converter = this.javaToNeo.get(javaType);
        if (converter != null) {
            return converter;
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)javaType;
            Type rawType = pt.getRawType();
            if (rawType == List.class) {
                Type type = pt.getActualTypeArguments()[0];
                return TypeMappers.toList(this.converterFor(type), type);
            }
            if (rawType == Map.class) {
                Type type = pt.getActualTypeArguments()[0];
                if (type != String.class) {
                    throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Maps are required to have `String` keys - but this map has `%s` keys.", new Object[]{type.getTypeName()});
                }
                return TO_MAP;
            }
        }
        throw this.javaToNeoMappingError(javaType);
    }

    void registerType(Class<?> javaClass, DefaultValueConverter toNeo) {
        this.javaToNeo.put(javaClass, toNeo);
    }

    private static DefaultValueConverter toList(DefaultValueConverter inner2, Type type) {
        return new DefaultValueConverter((Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)inner2.type()), List.class, new ListConverter(type, inner2.type()));
    }

    private ProcedureException javaToNeoMappingError(Type cls) {
        List types2 = Iterables.asList(this.javaToNeo.keySet()).stream().map(Type::getTypeName).sorted(String::compareTo).collect(Collectors.toList());
        return new ProcedureException((Status)Status.Statement.TypeError, "Don't know how to map `%s` to the Neo4j Type System.%nPlease refer to to the documentation for full details.%nFor your reference, known types are: %s", new Object[]{cls.getTypeName(), types2});
    }

    public static final class DefaultValueConverter
    extends TypeChecker {
        private final Function<String, DefaultParameterValue> parser;

        public DefaultValueConverter(Neo4jTypes.AnyType type, Class<?> javaClass) {
            this(type, javaClass, DefaultValueConverter.nullParser(javaClass, type));
        }

        private DefaultValueConverter(Neo4jTypes.AnyType type, Class<?> javaClass, Function<String, DefaultParameterValue> parser) {
            super(type, javaClass);
            this.parser = parser;
        }

        public Optional<DefaultParameterValue> defaultValue(Name parameter) throws ProcedureException {
            String defaultValue = parameter.defaultValue();
            if (defaultValue.equals(" <[6795b15e-8693-4a21-b57a-4a7b87f09a5a]> ")) {
                return Optional.empty();
            }
            try {
                return Optional.of(this.parser.apply(defaultValue));
            }
            catch (Exception e) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Default value `%s` could not be parsed as a %s", new Object[]{parameter.defaultValue(), this.javaClass.getSimpleName()});
            }
        }

        private static Function<String, DefaultParameterValue> nullParser(Class<?> javaType, Neo4jTypes.AnyType neoType) {
            return s2 -> {
                if (s2.equalsIgnoreCase("null")) {
                    return DefaultParameterValue.nullValue((Neo4jTypes.AnyType)neoType);
                }
                throw new IllegalArgumentException(String.format("A %s can only have a `defaultValue = \"null\"", javaType.getSimpleName()));
            };
        }
    }

    public static abstract class TypeChecker {
        final Neo4jTypes.AnyType type;
        final Class<?> javaClass;

        private TypeChecker(Neo4jTypes.AnyType type, Class<?> javaClass) {
            this.type = type;
            this.javaClass = javaClass;
        }

        public Neo4jTypes.AnyType type() {
            return this.type;
        }

        public Object typeCheck(Object javaValue) throws ProcedureException {
            if (javaValue == null || this.javaClass.isInstance(javaValue)) {
                return javaValue;
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Expected `%s` to be a `%s`, found `%s`.", new Object[]{javaValue, this.javaClass.getSimpleName(), javaValue.getClass()});
        }

        public AnyValue toValue(Object obj) {
            return ValueUtils.of(obj);
        }
    }
}

