/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a Date instant.")
class DateFunction
extends TemporalFunction<DateValue> {
    DateFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTDate, defaultZone);
    }

    @Override
    protected DateValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? DateValue.now(clock, defaultZone) : DateValue.now(clock, timezone);
    }

    @Override
    protected DateValue parse(TextValue value2, Supplier<ZoneId> defaultZone) {
        return DateValue.parse(value2);
    }

    @Override
    protected DateValue build(MapValue map2, Supplier<ZoneId> defaultZone) {
        return DateValue.build(map2, defaultZone);
    }

    @Override
    protected DateValue select(AnyValue from2, Supplier<ZoneId> defaultZone) {
        return DateValue.select(from2, defaultZone);
    }

    @Override
    protected DateValue truncate(TemporalUnit unit, TemporalValue input2, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateValue.truncate(unit, input2, fields, defaultZone);
    }
}

