/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.CallableUserFunction;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a DateTime instant.")
class DateTimeFunction
extends TemporalFunction<DateTimeValue> {
    DateTimeFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, defaultZone);
    }

    @Override
    protected DateTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? DateTimeValue.now(clock, defaultZone) : DateTimeValue.now(clock, timezone);
    }

    @Override
    protected DateTimeValue parse(TextValue value2, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse(value2, defaultZone);
    }

    @Override
    protected DateTimeValue build(MapValue map2, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.build(map2, defaultZone);
    }

    @Override
    protected DateTimeValue select(AnyValue from2, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.select(from2, defaultZone);
    }

    @Override
    protected DateTimeValue truncate(TemporalUnit unit, TemporalValue input2, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.truncate(unit, input2, fields, defaultZone);
    }

    @Override
    void registerMore(Procedures procedures) throws ProcedureException {
        procedures.register(new FromEpoch());
        procedures.register(new FromEpochMillis());
    }

    private static class FromEpochMillis
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Create a DateTime given the milliseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"milliseconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName(new String[]{"datetime"}, "fromepochmillis"), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, null, new String[0], "Create a DateTime given the milliseconds since the start of the epoch.", true);

        private FromEpochMillis() {
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input2) throws ProcedureException {
            if (input2 != null && input2.length == 1 && input2[0] instanceof IntegralValue) {
                IntegralValue milliseconds = (IntegralValue)input2[0];
                return DateTimeValue.ofEpochMillis(milliseconds);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input2), new Object[0]);
        }
    }

    private static class FromEpoch
    implements CallableUserFunction {
        private static final String DESCRIPTION = "Create a DateTime given the seconds and nanoseconds since the start of the epoch.";
        private static final List<FieldSignature> SIGNATURE = Arrays.asList(FieldSignature.inputField((String)"seconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber), FieldSignature.inputField((String)"nanoseconds", (Neo4jTypes.AnyType)Neo4jTypes.NTNumber));
        private final UserFunctionSignature signature = new UserFunctionSignature(new QualifiedName(new String[]{"datetime"}, "fromepoch"), SIGNATURE, (Neo4jTypes.AnyType)Neo4jTypes.NTDateTime, null, new String[0], "Create a DateTime given the seconds and nanoseconds since the start of the epoch.", true);

        private FromEpoch() {
        }

        @Override
        public UserFunctionSignature signature() {
            return this.signature;
        }

        @Override
        public AnyValue apply(Context ctx, AnyValue[] input2) throws ProcedureException {
            if (input2 != null && input2.length == 2 && input2[0] instanceof IntegralValue && input2[1] instanceof IntegralValue) {
                IntegralValue seconds = (IntegralValue)input2[0];
                IntegralValue nanoseconds = (IntegralValue)input2[1];
                return DateTimeValue.ofEpoch(seconds, nanoseconds);
            }
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Invalid call signature for " + this.getClass().getSimpleName() + ": Provided input was " + Arrays.toString(input2), new Object[0]);
        }
    }
}

