/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.kernel.impl.proc.temporal.TemporalFunction;
import org.neo4j.procedure.Description;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Create a LocalTime instant.")
class LocalTimeFunction
extends TemporalFunction<LocalTimeValue> {
    LocalTimeFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTLocalTime, defaultZone);
    }

    @Override
    protected LocalTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? LocalTimeValue.now(clock, defaultZone) : LocalTimeValue.now(clock, timezone);
    }

    @Override
    protected LocalTimeValue parse(TextValue value2, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.parse(value2);
    }

    @Override
    protected LocalTimeValue build(MapValue map2, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.build(map2, defaultZone);
    }

    @Override
    protected LocalTimeValue select(AnyValue from2, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.select(from2, defaultZone);
    }

    @Override
    protected LocalTimeValue truncate(TemporalUnit unit, TemporalValue input2, MapValue fields, Supplier<ZoneId> defaultZone) {
        return LocalTimeValue.truncate(unit, input2, fields, defaultZone);
    }
}

