/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.scheduler.GroupedDaemonThreadFactory;
import org.neo4j.kernel.impl.scheduler.ThreadPoolManager;
import org.neo4j.kernel.impl.scheduler.TimeBasedTaskScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.Clocks;

public class CentralJobScheduler
extends LifecycleAdapter
implements JobScheduler,
AutoCloseable {
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger();
    private final TimeBasedTaskScheduler scheduler;
    private final Thread schedulerThread;
    private final ConcurrentHashMap<Group, ExecutorService> workStealingExecutors = new ConcurrentHashMap(1);
    private final TopLevelGroup topLevelGroup = new TopLevelGroup();
    private final ThreadPoolManager pools = new ThreadPoolManager(this.topLevelGroup);
    private volatile boolean started;

    protected CentralJobScheduler() {
        GroupedDaemonThreadFactory threadFactory = new GroupedDaemonThreadFactory(Group.TASK_SCHEDULER, this.topLevelGroup);
        this.scheduler = new TimeBasedTaskScheduler(Clocks.nanoClock(), this.pools);
        this.schedulerThread = threadFactory.newThread(this.scheduler);
        int priority = 6;
        this.schedulerThread.setPriority(priority);
    }

    @Override
    public void setTopLevelGroupName(String name) {
        try {
            this.topLevelGroup.setName(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init() {
        if (!this.started) {
            this.schedulerThread.start();
            this.started = true;
        }
    }

    @Override
    public Executor executor(Group group) {
        return job -> this.schedule(group, job);
    }

    @Override
    public ExecutorService workStealingExecutor(Group group, int parallelism) {
        return this.workStealingExecutor(group, parallelism, false);
    }

    @Override
    public ExecutorService workStealingExecutorAsyncMode(Group group, int parallelism) {
        return this.workStealingExecutor(group, parallelism, true);
    }

    private ExecutorService workStealingExecutor(Group group, int parallelism, boolean asyncMode) {
        return this.workStealingExecutors.computeIfAbsent(group, g -> this.createNewWorkStealingExecutor((Group)((Object)g), parallelism, asyncMode));
    }

    @Override
    public ThreadFactory threadFactory(Group group) {
        return this.pools.getThreadPool(group).getThreadFactory();
    }

    private ExecutorService createNewWorkStealingExecutor(Group group, int parallelism, boolean asyncMode) {
        GroupedDaemonThreadFactory factory = new GroupedDaemonThreadFactory(group, this.topLevelGroup);
        return new ForkJoinPool(parallelism, factory, null, asyncMode);
    }

    @Override
    public JobHandle schedule(Group group, Runnable job) {
        if (!this.started) {
            throw new RejectedExecutionException("Scheduler is not started");
        }
        return this.pools.submit(group, job);
    }

    @Override
    public JobHandle scheduleRecurring(Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        return this.scheduleRecurring(group, runnable, 0L, period, timeUnit);
    }

    @Override
    public JobHandle scheduleRecurring(Group group, Runnable runnable, long initialDelay, long period, TimeUnit unit) {
        return this.scheduler.submit(group, runnable, unit.toNanos(initialDelay), unit.toNanos(period));
    }

    @Override
    public JobHandle schedule(Group group, Runnable runnable, long initialDelay, TimeUnit unit) {
        return this.scheduler.submit(group, runnable, unit.toNanos(initialDelay), 0L);
    }

    @Override
    public void shutdown() {
        this.started = false;
        InterruptedException exception = this.shutDownScheduler();
        exception = Exceptions.chain(exception, this.pools.shutDownAll());
        for (ExecutorService workStealingExecutor : this.workStealingExecutors.values()) {
            exception = this.shutdownPool(workStealingExecutor, exception);
        }
        this.workStealingExecutors.clear();
        if (exception != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private InterruptedException shutDownScheduler() {
        this.scheduler.stop();
        try {
            this.schedulerThread.join();
        }
        catch (InterruptedException e) {
            return e;
        }
        return null;
    }

    private InterruptedException shutdownPool(ExecutorService pool, InterruptedException exception) {
        if (pool != null) {
            pool.shutdown();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return Exceptions.chain(exception, e);
            }
        }
        return exception;
    }

    private static class TopLevelGroup
    extends ThreadGroup {
        TopLevelGroup() {
            super("Neo4j-" + INSTANCE_COUNTER.incrementAndGet());
        }

        public void setName(String name) throws Exception {
            Field field2 = ThreadGroup.class.getDeclaredField("name");
            field2.setAccessible(true);
            field2.set(this, name);
        }
    }
}

