/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.SchedulerThreadFactory;

final class GroupedDaemonThreadFactory
implements SchedulerThreadFactory {
    private final Group group;
    private final ThreadGroup threadGroup;

    GroupedDaemonThreadFactory(Group group, ThreadGroup parentThreadGroup) {
        this.group = group;
        this.threadGroup = new ThreadGroup(parentThreadGroup, group.groupName());
    }

    @Override
    public Thread newThread(Runnable job) {
        Thread thread = new Thread(this.threadGroup, job, this.group.threadName()){

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder("Thread[").append(this.getName());
                String sep = ", in ";
                for (ThreadGroup group = this.getThreadGroup(); group != null; group = group.getParent()) {
                    sb.append(sep).append(group.getName());
                    sep = "/";
                }
                return sb.append(']').toString();
            }
        };
        thread.setDaemon(true);
        return thread;
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = ForkJoinPool.defaultForkJoinWorkerThreadFactory;
        AtomicReference reference = new AtomicReference();
        Thread allocator = this.newThread(() -> reference.set(factory.newThread(pool)));
        allocator.start();
        do {
            try {
                allocator.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (reference.get() == null);
        ForkJoinWorkerThread worker = (ForkJoinWorkerThread)reference.get();
        worker.setName(this.group.threadName());
        return worker;
    }
}

