/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.scheduler;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.neo4j.scheduler.CancelListener;
import org.neo4j.scheduler.JobHandle;

final class PooledJobHandle
implements JobHandle {
    private final Future<?> future;
    private final Object registryKey;
    private final ConcurrentHashMap<Object, Future<?>> registry;
    private final List<CancelListener> cancelListeners = new CopyOnWriteArrayList<CancelListener>();

    PooledJobHandle(Future<?> future, Object registryKey, ConcurrentHashMap<Object, Future<?>> registry) {
        this.future = future;
        this.registryKey = registryKey;
        this.registry = registry;
    }

    @Override
    public void cancel(boolean mayInterruptIfRunning) {
        this.future.cancel(mayInterruptIfRunning);
        for (CancelListener cancelListener : this.cancelListeners) {
            cancelListener.cancelled(mayInterruptIfRunning);
        }
        this.registry.remove(this.registryKey);
    }

    @Override
    public void waitTermination() throws InterruptedException, ExecutionException {
        this.future.get();
    }

    @Override
    public void registerCancelListener(CancelListener listener) {
        this.cancelListeners.add(listener);
    }
}

