/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.SchemaCache;
import org.neo4j.kernel.impl.core.TokenHolders;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordNodeCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordPropertyCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipGroupCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.StorageSchemaReaderSnapshot;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipGroupCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class RecordStorageReader
implements StorageReader {
    private final TokenHolders tokenHolders;
    private final IndexingService indexService;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final PropertyStore propertyStore;
    private final SchemaStorage schemaStorage;
    private final CountsTracker counts;
    private final SchemaCache schemaCache;
    private final Supplier<IndexReaderFactory> indexReaderFactorySupplier;
    private final Supplier<LabelScanReader> labelScanReaderSupplier;
    private final RecordStorageCommandCreationContext commandCreationContext;
    private IndexReaderFactory indexReaderFactory;
    private LabelScanReader labelScanReader;
    private boolean acquired;
    private boolean closed;

    RecordStorageReader(TokenHolders tokenHolders, SchemaStorage schemaStorage, NeoStores neoStores, IndexingService indexService, SchemaCache schemaCache, Supplier<IndexReaderFactory> indexReaderFactory, Supplier<LabelScanReader> labelScanReaderSupplier, RecordStorageCommandCreationContext commandCreationContext) {
        this.tokenHolders = tokenHolders;
        this.neoStores = neoStores;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.counts = neoStores.getCounts();
        this.schemaCache = schemaCache;
        this.indexReaderFactorySupplier = indexReaderFactory;
        this.labelScanReaderSupplier = labelScanReaderSupplier;
        this.commandCreationContext = commandCreationContext;
    }

    public RecordStorageReader(NeoStores stores) {
        this(null, null, stores, null, null, null, null, null);
    }

    public PrimitiveLongResourceIterator nodesGetForLabel(int labelId) {
        return this.getLabelScanReader().nodesWithLabel(labelId);
    }

    public CapableIndexDescriptor indexGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.indexDescriptor(descriptor);
    }

    public Iterator<CapableIndexDescriptor> indexesGetForLabel(int labelId) {
        return this.schemaCache.indexDescriptorsForLabel(labelId);
    }

    public Iterator<CapableIndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        return this.schemaCache.indexDescriptorsForRelationshipType(relationshipType);
    }

    public CapableIndexDescriptor indexGetForName(String name) {
        return this.schemaCache.indexDescriptorForName(name);
    }

    public Iterator<CapableIndexDescriptor> indexesGetAll() {
        return this.schemaCache.indexDescriptors().iterator();
    }

    public Iterator<CapableIndexDescriptor> indexesGetRelatedToProperty(int propertyId) {
        return this.schemaCache.indexesByProperty(propertyId);
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        StoreIndexDescriptor storeIndexDescriptor = this.getStoreIndexDescriptor(index);
        if (storeIndexDescriptor != null) {
            Long owningConstraint = storeIndexDescriptor.getOwningConstraint();
            return this.schemaCache.hasConstraintRule(owningConstraint) ? owningConstraint : null;
        }
        return null;
    }

    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor.schema()).getState();
    }

    public IndexReference indexReference(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        IndexProxy indexProxy = this.indexService.getIndexProxy(descriptor.schema());
        return indexProxy.getDescriptor();
    }

    public PopulationProgress indexGetPopulationProgress(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getIndexPopulationProgress();
    }

    public long indexSize(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        Register.DoubleLongRegister result2 = this.indexService.indexUpdatesAndSize(descriptor);
        return result2.readSecond();
    }

    public double indexUniqueValuesPercentage(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.indexUniqueValuesPercentage(descriptor);
    }

    public String indexGetFailure(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(descriptor).getPopulationFailure().asString();
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        return this.schemaCache.constraintsForSchema(descriptor);
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        return this.schemaCache.hasConstraintRule(descriptor);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return this.schemaCache.constraintsForLabel(labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return this.schemaCache.constraintsForRelationshipType(typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return this.schemaCache.constraints();
    }

    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        RelationshipRecord record = (RelationshipRecord)this.relationshipStore.getRecord(relationshipId, this.relationshipStore.newRecord(), RecordLoad.CHECK);
        if (!record.inUse()) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId);
        }
        relationshipVisitor.visit(relationshipId, record.getType(), record.getFirstNode(), record.getSecondNode());
    }

    public void releaseNode(long id2) {
        this.nodeStore.freeId(id2);
    }

    public void releaseRelationship(long id2) {
        this.relationshipStore.freeId(id2);
    }

    public long countsForNode(int labelId) {
        return this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
    }

    public long nodesGetCount() {
        return this.nodeStore.getNumberOfIdsInUse();
    }

    public long relationshipsGetCount() {
        return this.relationshipStore.getNumberOfIdsInUse();
    }

    public int labelCount() {
        return this.tokenHolders.labelTokens().size();
    }

    public int propertyKeyCount() {
        return this.tokenHolders.propertyKeyTokens().size();
    }

    public int relationshipTypeCount() {
        return this.tokenHolders.relationshipTypeTokens().size();
    }

    public Register.DoubleLongRegister indexUpdatesAndSize(SchemaDescriptor descriptor, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.counts.indexUpdatesAndSize(this.tryGetIndexId(descriptor), target);
    }

    public Register.DoubleLongRegister indexSample(SchemaDescriptor descriptor, Register.DoubleLongRegister target) throws IndexNotFoundKernelException {
        return this.counts.indexSample(this.tryGetIndexId(descriptor), target);
    }

    private long tryGetIndexId(SchemaDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexId(descriptor);
    }

    public boolean nodeExists(long id2) {
        return this.nodeStore.isInUse(id2);
    }

    public boolean relationshipExists(long id2) {
        return this.relationshipStore.isInUse(id2);
    }

    private StoreIndexDescriptor getStoreIndexDescriptor(IndexDescriptor index) {
        for (StoreIndexDescriptor storeIndexDescriptor : this.schemaCache.indexDescriptors()) {
            if (!storeIndexDescriptor.equals((Object)index)) continue;
            return storeIndexDescriptor;
        }
        return this.schemaStorage.indexGetForSchema(index);
    }

    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        return this.schemaCache.getOrCreateDependantState(type, factory, this);
    }

    public void acquire() {
        assert (!this.closed);
        assert (!this.acquired);
        this.acquired = true;
    }

    public void release() {
        assert (!this.closed);
        assert (this.acquired);
        this.closeSchemaResources();
        this.acquired = false;
    }

    public void close() {
        assert (!this.closed);
        this.closeSchemaResources();
        if (this.commandCreationContext != null) {
            this.commandCreationContext.close();
        }
        this.closed = true;
    }

    private void closeSchemaResources() {
        if (this.indexReaderFactory != null) {
            this.indexReaderFactory.close();
        }
        if (this.labelScanReader != null) {
            this.labelScanReader.close();
            this.labelScanReader = null;
        }
    }

    public LabelScanReader getLabelScanReader() {
        return this.labelScanReader != null ? this.labelScanReader : (this.labelScanReader = this.labelScanReaderSupplier.get());
    }

    private IndexReaderFactory indexReaderFactory() {
        return this.indexReaderFactory != null ? this.indexReaderFactory : (this.indexReaderFactory = this.indexReaderFactorySupplier.get());
    }

    public IndexReader getIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newReader(descriptor);
    }

    public IndexReader getFreshIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newUnCachedReader(descriptor);
    }

    RecordStorageCommandCreationContext getCommandCreationContext() {
        return this.commandCreationContext;
    }

    public long reserveNode() {
        return this.commandCreationContext.nextId(StoreType.NODE);
    }

    public long reserveRelationship() {
        return this.commandCreationContext.nextId(StoreType.RELATIONSHIP);
    }

    public int reserveRelationshipTypeTokenId() {
        return Math.toIntExact(this.neoStores.getRelationshipTypeTokenStore().nextId());
    }

    public int reservePropertyKeyTokenId() {
        return Math.toIntExact(this.neoStores.getPropertyKeyTokenStore().nextId());
    }

    public int reserveLabelTokenId() {
        return Math.toIntExact(this.neoStores.getLabelTokenStore().nextId());
    }

    public long getGraphPropertyReference() {
        return this.neoStores.getMetaDataStore().getGraphNextProp();
    }

    public RecordNodeCursor allocateNodeCursor() {
        return new RecordNodeCursor(this.nodeStore);
    }

    public StorageRelationshipGroupCursor allocateRelationshipGroupCursor() {
        return new RecordRelationshipGroupCursor(this.relationshipStore, this.relationshipGroupStore);
    }

    public StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor() {
        return new RecordRelationshipTraversalCursor(this.relationshipStore, this.relationshipGroupStore);
    }

    public RecordRelationshipScanCursor allocateRelationshipScanCursor() {
        return new RecordRelationshipScanCursor(this.relationshipStore);
    }

    public StorageSchemaReader schemaSnapshot() {
        return new StorageSchemaReaderSnapshot(this.schemaCache.snapshot(), this);
    }

    public StoragePropertyCursor allocatePropertyCursor() {
        return new RecordPropertyCursor(this.propertyStore);
    }
}

