/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public abstract class LongerShortString
extends Enum<LongerShortString> {
    public static final /* enum */ LongerShortString NUMERICAL;
    public static final /* enum */ LongerShortString DATE;
    public static final /* enum */ LongerShortString UPPER;
    public static final /* enum */ LongerShortString LOWER;
    public static final /* enum */ LongerShortString EMAIL;
    public static final /* enum */ LongerShortString URI;
    public static final /* enum */ LongerShortString ALPHANUM;
    public static final /* enum */ LongerShortString ALPHASYM;
    public static final /* enum */ LongerShortString EUROPEAN;
    public static final /* enum */ LongerShortString LOWERHEX;
    public static final /* enum */ LongerShortString UPPERHEX;
    public static final int REMOVE_LARGE_ENCODINGS_MASK;
    public static final LongerShortString[] ENCODINGS;
    public static final int ENCODING_COUNT;
    public static final int ALL_BIT_MASK;
    public static final int ENCODING_UTF8 = 0;
    public static final int ENCODING_LATIN1 = 10;
    private static final int HEADER_SIZE = 39;
    final int encodingHeader;
    final long mask;
    final int step;
    private static final char[] PUNCTUATION;
    private static final int TRANSLATION_COUNT = 256;
    private static final byte[] TRANSLATION;
    private static final int[] REMOVE_MASK;
    private static final LongerShortString[] ENCODINGS_BY_ENCODING;
    private static final /* synthetic */ LongerShortString[] $VALUES;

    public static LongerShortString[] values() {
        return (LongerShortString[])$VALUES.clone();
    }

    public static LongerShortString valueOf(String name) {
        return Enum.valueOf(LongerShortString.class, name);
    }

    private LongerShortString(int encodingHeader, int step) {
        this.encodingHeader = encodingHeader;
        this.mask = Bits.rightOverflowMask(step);
        this.step = step;
    }

    int maxLength(int payloadSize) {
        return ((payloadSize << 3) - 24 - 4 - 4 - 6) / this.step;
    }

    final IllegalArgumentException cannotEncode(byte b) {
        return new IllegalArgumentException("Cannot encode as " + this.name() + ": " + b);
    }

    final char decPunctuation(int code) {
        return PUNCTUATION[code];
    }

    int encTranslate(byte b) {
        if (b < 0) {
            return (0xFF & b) - 192;
        }
        if (b < 32) {
            return this.encPunctuation(b);
        }
        if (b >= 48 && b <= 52) {
            return 91 + b - 48;
        }
        if (b >= 53 && b <= 57) {
            return 123 + b - 53;
        }
        return b;
    }

    abstract int encPunctuation(byte var1);

    abstract char decTranslate(byte var1);

    public static boolean encode(int keyId, String string2, PropertyBlock target, int payloadSize) {
        int dataLength = string2.length();
        if (dataLength > NUMERICAL.maxLength(payloadSize) || dataLength > 63) {
            return false;
        }
        byte[] data = new byte[dataLength];
        int encodings = LongerShortString.determineEncoding(string2, data, dataLength, payloadSize);
        if (encodings != 0 && LongerShortString.tryEncode(encodings, keyId, target, payloadSize, data, dataLength)) {
            return true;
        }
        return LongerShortString.encodeWithCharSet(keyId, string2, target, payloadSize, dataLength);
    }

    private static boolean encodeWithCharSet(int keyId, String string2, PropertyBlock target, int payloadSize, int stringLength) {
        int maxBytes = PropertyType.getPayloadSize();
        if (stringLength <= maxBytes - 5) {
            return LongerShortString.encodeLatin1(keyId, string2, target) || LongerShortString.encodeUTF8(keyId, string2, target, payloadSize);
        }
        return false;
    }

    private static boolean tryEncode(int encodings, int keyId, PropertyBlock target, int payloadSize, byte[] data, int length2) {
        for (LongerShortString encoding : ENCODINGS) {
            if ((encoding.bitMask() & encodings) == 0 || !encoding.doEncode(keyId, data, target, payloadSize, length2)) continue;
            return true;
        }
        return false;
    }

    static int invertedBitMask(LongerShortString ... encoders) {
        return ~LongerShortString.bitMask(encoders);
    }

    private static int bitMask(LongerShortString[] encoders) {
        int result2 = 0;
        for (LongerShortString encoder : encoders) {
            result2 |= encoder.bitMask();
        }
        return result2;
    }

    private static void setUp(char pos, int value2, LongerShortString ... removeEncodings) {
        LongerShortString.TRANSLATION[pos] = (byte)value2;
        LongerShortString.REMOVE_MASK[pos] = LongerShortString.invertedBitMask(removeEncodings);
    }

    private static int determineEncoding(String string2, byte[] data, int length2, int payloadSize) {
        if (length2 == 0) {
            return 0;
        }
        int encodings = ALL_BIT_MASK;
        if (length2 > ALPHANUM.maxLength(payloadSize)) {
            encodings &= REMOVE_LARGE_ENCODINGS_MASK;
        }
        for (int i = 0; i < length2; ++i) {
            char c = string2.charAt(i);
            if (c >= '\u0100') {
                return 0;
            }
            data[i] = TRANSLATION[c];
            if ((encodings &= REMOVE_MASK[c]) != 0) continue;
            return 0;
        }
        return encodings;
    }

    int bitMask() {
        return 1 << this.ordinal();
    }

    private static void writeHeader(Bits bits2, int keyId, int encoding, int stringLength) {
        bits2.put(keyId, 24).put(PropertyType.SHORT_STRING.intValue(), 4).put(encoding, 5).put(stringLength, 6);
    }

    public static TextValue decode(PropertyBlock block) {
        return LongerShortString.decode(block.getValueBlocks(), 0, block.getValueBlocks().length);
    }

    public static TextValue decode(long[] blocks, int offset, int length2) {
        long firstLong = blocks[offset];
        if ((firstLong & 0xFFFFFF0FFFFFFFFFL) == 0L) {
            return Values.EMPTY_STRING;
        }
        int encoding = (int)((firstLong & 0x1F0000000L) >>> 28);
        int stringLength = (int)((firstLong & 0x7E00000000L) >>> 33);
        if (encoding == 0) {
            return LongerShortString.decodeUTF8(blocks, offset, stringLength);
        }
        if (encoding == 10) {
            return LongerShortString.decodeLatin1(blocks, offset, stringLength);
        }
        LongerShortString table = LongerShortString.getEncodingTable(encoding);
        assert (table != null) : "We only decode LongerShortStrings after we have consistently read the PropertyBlock data from the page cache. Thus, we should never have an invalid encoding header here.";
        char[] result2 = new char[stringLength];
        LongerShortString.decode(result2, blocks, offset, table);
        return Values.stringValue(UnsafeUtil.newSharedArrayString((char[])result2));
    }

    private static void decode(char[] result2, long[] blocks, int offset, LongerShortString table) {
        int block = offset;
        int maskShift = 39;
        long baseMask = table.mask;
        for (int i = 0; i < result2.length; ++i) {
            byte codePoint = (byte)(blocks[block] >>> maskShift & baseMask);
            if ((maskShift += table.step) >= 64 && block + 1 < blocks.length) {
                codePoint = (byte)((long)codePoint | (blocks[++block] & baseMask >>> table.step - (maskShift %= 64)) << table.step - maskShift);
            }
            result2[i] = table.decTranslate(codePoint);
        }
    }

    private static LongerShortString getEncodingTable(int encodingHeader) {
        if (encodingHeader < 0 | ENCODINGS_BY_ENCODING.length <= encodingHeader) {
            return null;
        }
        return ENCODINGS_BY_ENCODING[encodingHeader];
    }

    private static Bits newBits(LongerShortString encoding, int length2) {
        return Bits.bits(LongerShortString.calculateNumberOfBlocksUsed(encoding, length2) << 3);
    }

    private static Bits newBitsForStep8(int length2) {
        return Bits.bits(LongerShortString.calculateNumberOfBlocksUsedForStep8(length2) << 3);
    }

    private static boolean encodeLatin1(int keyId, String string2, PropertyBlock target) {
        int length2 = string2.length();
        Bits bits2 = LongerShortString.newBitsForStep8(length2);
        LongerShortString.writeHeader(bits2, keyId, 10, length2);
        if (!LongerShortString.writeLatin1Characters(string2, bits2)) {
            return false;
        }
        target.setValueBlocks(bits2.getLongs());
        return true;
    }

    public static boolean writeLatin1Characters(String string2, Bits bits2) {
        int length2 = string2.length();
        for (int i = 0; i < length2; ++i) {
            char c = string2.charAt(i);
            if (c >= '\u0100') {
                return false;
            }
            bits2.put(c, 8);
        }
        return true;
    }

    private static boolean encodeUTF8(int keyId, String string2, PropertyBlock target, int payloadSize) {
        byte[] bytes2 = string2.getBytes(StandardCharsets.UTF_8);
        int length2 = bytes2.length;
        if (length2 > payloadSize - 3 - 2) {
            return false;
        }
        Bits bits2 = LongerShortString.newBitsForStep8(length2);
        LongerShortString.writeHeader(bits2, keyId, 0, length2);
        for (byte value2 : bytes2) {
            bits2.put(value2);
        }
        target.setValueBlocks(bits2.getLongs());
        return true;
    }

    private boolean doEncode(int keyId, byte[] data, PropertyBlock target, int payloadSize, int length2) {
        if (length2 > this.maxLength(payloadSize)) {
            return false;
        }
        Bits bits2 = LongerShortString.newBits(this, length2);
        LongerShortString.writeHeader(bits2, keyId, this.encodingHeader, length2);
        if (length2 > 0) {
            this.translateData(bits2, data, length2, this.step);
        }
        target.setValueBlocks(bits2.getLongs());
        return true;
    }

    private void translateData(Bits bits2, byte[] data, int length2, int step) {
        for (int i = 0; i < length2; ++i) {
            bits2.put(this.encTranslate(data[i]), step);
        }
    }

    private static TextValue decodeLatin1(long[] blocks, int offset, int stringLength) {
        char[] result2 = new char[stringLength];
        int block = offset;
        int maskShift = 39;
        for (int i = 0; i < result2.length; ++i) {
            char codePoint = (char)(blocks[block] >>> maskShift & 0xFFL);
            if ((maskShift += 8) >= 64) {
                codePoint = (char)((long)codePoint | (blocks[++block] & (long)(255 >>> 8 - (maskShift %= 64))) << 8 - maskShift);
            }
            result2[i] = codePoint;
        }
        return Values.stringValue(UnsafeUtil.newSharedArrayString((char[])result2));
    }

    private static TextValue decodeUTF8(long[] blocks, int offset, int stringLength) {
        byte[] result2 = new byte[stringLength];
        int block = offset;
        int maskShift = 39;
        for (int i = 0; i < result2.length; ++i) {
            byte codePoint = (byte)(blocks[block] >>> maskShift);
            if ((maskShift += 8) >= 64) {
                codePoint = (byte)((long)codePoint | (blocks[++block] & (long)(255 >>> 8 - (maskShift %= 64))) << 8 - maskShift);
            }
            result2[i] = codePoint;
        }
        return Values.utf8Value(result2);
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        int encoding = (int)((firstBlock & 0x1F0000000L) >> 28);
        int length2 = (int)((firstBlock & 0x7E00000000L) >> 33);
        if (encoding == 0 || encoding == 10) {
            return LongerShortString.calculateNumberOfBlocksUsedForStep8(length2);
        }
        LongerShortString encodingTable = LongerShortString.getEncodingTable(encoding);
        if (encodingTable == null) {
            return -1;
        }
        return LongerShortString.calculateNumberOfBlocksUsed(encodingTable, length2);
    }

    public static int calculateNumberOfBlocksUsedForStep8(int length2) {
        return LongerShortString.totalBits(length2 << 3);
    }

    public static int calculateNumberOfBlocksUsed(LongerShortString encoding, int length2) {
        return LongerShortString.totalBits(length2 * encoding.step);
    }

    private static int totalBits(int bitsForCharacters) {
        int bitsInTotal = 39 + bitsForCharacters;
        return (bitsInTotal - 1 >> 6) + 1;
    }

    static {
        char c;
        NUMERICAL = new LongerShortString(1, 4){

            @Override
            int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                switch (b) {
                    case 0: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                    case 3: {
                        return 12;
                    }
                    case 6: {
                        return 13;
                    }
                    case 7: {
                        return 14;
                    }
                    case 8: {
                        return 15;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (char)(codePoint + 48);
                }
                return this.decPunctuation(codePoint - 10 + 6);
            }
        };
        DATE = new LongerShortString(2, 4){

            @Override
            int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                switch (b) {
                    case 0: {
                        return 10;
                    }
                    case 3: {
                        return 11;
                    }
                    case 4: {
                        return 12;
                    }
                    case 5: {
                        return 13;
                    }
                    case 6: {
                        return 14;
                    }
                    case 7: {
                        return 15;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (char)(codePoint + 48);
                }
                switch (codePoint) {
                    case 10: {
                        return ' ';
                    }
                    case 11: {
                        return '-';
                    }
                    case 12: {
                        return ':';
                    }
                    case 13: {
                        return '/';
                    }
                    case 14: {
                        return '+';
                    }
                }
                return ',';
            }
        };
        UPPER = new LongerShortString(3, 5){

            @Override
            int encTranslate(byte b) {
                return super.encTranslate(b) - 64;
            }

            @Override
            int encPunctuation(byte b) {
                return b == 0 ? 64 : b + 90;
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 65 - 1);
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        LOWER = new LongerShortString(4, 5){

            @Override
            int encTranslate(byte b) {
                return super.encTranslate(b) - 96;
            }

            @Override
            int encPunctuation(byte b) {
                return b == 0 ? 96 : b + 122;
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 97 - 1);
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        EMAIL = new LongerShortString(5, 5){

            @Override
            int encTranslate(byte b) {
                return super.encTranslate(b) - 96;
            }

            @Override
            int encPunctuation(byte b) {
                int encOffset = 96;
                if (b == 7) {
                    return encOffset;
                }
                int offset = encOffset + 27;
                switch (b) {
                    case 1: {
                        return 0 + offset;
                    }
                    case 2: {
                        return 1 + offset;
                    }
                    case 3: {
                        return 2 + offset;
                    }
                    case 6: {
                        return 3 + offset;
                    }
                    case 9: {
                        return 4 + offset;
                    }
                }
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ',';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 97 - 1);
                }
                switch (codePoint) {
                    case 30: {
                        return '+';
                    }
                    case 31: {
                        return '@';
                    }
                }
                return this.decPunctuation(codePoint - 26);
            }
        };
        URI = new LongerShortString(6, 6){

            @Override
            int encTranslate(byte b) {
                if (b == 0) {
                    return 0;
                }
                if (b >= 97 && b <= 122) {
                    return b - 96;
                }
                if (b >= 48 && b <= 57) {
                    return b - 16;
                }
                if (b >= 1 && b <= 22) {
                    return b + 41;
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(codePoint + 97 - 1);
                }
                if (codePoint <= 41) {
                    return (char)(codePoint - 32 + 48);
                }
                if (codePoint <= 46) {
                    return this.decPunctuation(codePoint - 41);
                }
                return this.decPunctuation(codePoint - 47 + 9);
            }
        };
        ALPHANUM = new LongerShortString(7, 6){

            @Override
            char decTranslate(byte codePoint) {
                return EUROPEAN.decTranslate((byte)(codePoint + 64));
            }

            @Override
            int encTranslate(byte b) {
                if (b < 32) {
                    return this.encPunctuation(b);
                }
                return EUROPEAN.encTranslate(b) - 64;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 32;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        ALPHASYM = new LongerShortString(8, 6){

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint == 0) {
                    return ' ';
                }
                if (codePoint <= 26) {
                    return (char)(65 + codePoint - 1);
                }
                if (codePoint <= 31) {
                    return this.decPunctuation(codePoint - 27 + 1);
                }
                if (codePoint == 32) {
                    return ';';
                }
                if (codePoint <= 58) {
                    return (char)(97 + codePoint - 33);
                }
                return this.decPunctuation(codePoint - 59 + 9);
            }

            @Override
            int encTranslate(byte b) {
                if (b < 32) {
                    return this.encPunctuation(b);
                }
                return b - 64;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 27;
                    }
                    case 2: {
                        return 28;
                    }
                    case 3: {
                        return 29;
                    }
                    case 4: {
                        return 30;
                    }
                    case 5: {
                        return 31;
                    }
                    case 6: {
                        return 59;
                    }
                    case 7: {
                        return 60;
                    }
                    case 8: {
                        return 61;
                    }
                    case 9: {
                        return 62;
                    }
                    case 10: {
                        return 63;
                    }
                    case 11: {
                        return 32;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        EUROPEAN = new LongerShortString(9, 7){

            @Override
            char decTranslate(byte codePoint) {
                int code = codePoint & 0xFF;
                if (code < 64) {
                    if (code == 23) {
                        return '.';
                    }
                    if (code == 55) {
                        return '-';
                    }
                    return (char)(code + 192);
                }
                if (code == 64) {
                    return ' ';
                }
                if (code == 96) {
                    return '_';
                }
                if (code >= 91 && code < 96) {
                    return (char)(48 + code - 91);
                }
                if (code >= 123 && code < 128) {
                    return (char)(53 + code - 123);
                }
                return (char)code;
            }

            @Override
            int encPunctuation(byte b) {
                switch (b) {
                    case 0: {
                        return 64;
                    }
                    case 1: {
                        return 96;
                    }
                    case 2: {
                        return 23;
                    }
                    case 3: {
                        return 55;
                    }
                    case 7: {
                        return 0;
                    }
                }
                throw this.cannotEncode(b);
            }
        };
        LOWERHEX = new LongerShortString(11, 4){

            @Override
            int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                if (b >= 97 && b <= 102) {
                    return b - 97 + 10;
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (char)(codePoint + 48);
                }
                return (char)(codePoint + 97 - 10);
            }
        };
        UPPERHEX = new LongerShortString(12, 4){

            @Override
            int encTranslate(byte b) {
                if (b >= 48 && b <= 57) {
                    return b - 48;
                }
                if (b >= 65 && b <= 70) {
                    return b - 65 + 10;
                }
                throw this.cannotEncode(b);
            }

            @Override
            int encPunctuation(byte b) {
                throw this.cannotEncode(b);
            }

            @Override
            char decTranslate(byte codePoint) {
                if (codePoint < 10) {
                    return (char)(codePoint + 48);
                }
                return (char)(codePoint + 65 - 10);
            }
        };
        $VALUES = new LongerShortString[]{NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, ALPHASYM, EUROPEAN, LOWERHEX, UPPERHEX};
        REMOVE_LARGE_ENCODINGS_MASK = LongerShortString.invertedBitMask(ALPHANUM, ALPHASYM, URI, EUROPEAN);
        ENCODINGS = LongerShortString.values();
        ENCODING_COUNT = ENCODINGS.length;
        ALL_BIT_MASK = LongerShortString.bitMask(LongerShortString.values());
        PUNCTUATION = new char[]{' ', '_', '.', '-', ':', '/', ' ', '.', '-', '+', ',', '\'', '@', '|', ';', '*', '?', '&', '%', '#', '(', ')', '$', '<', '>', '='};
        TRANSLATION = new byte[256];
        REMOVE_MASK = new int[256];
        Arrays.fill(TRANSLATION, (byte)-1);
        Arrays.fill(REMOVE_MASK, LongerShortString.invertedBitMask(ENCODINGS));
        LongerShortString.setUp(' ', 0, EMAIL, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('_', 1, NUMERICAL, DATE, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('.', 2, DATE, ALPHANUM, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('-', 3, ALPHANUM, LOWERHEX, UPPERHEX);
        LongerShortString.setUp(':', 4, ALPHANUM, NUMERICAL, EUROPEAN, EMAIL, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('/', 5, ALPHANUM, NUMERICAL, EUROPEAN, EMAIL, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('+', 6, UPPER, LOWER, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        LongerShortString.setUp(',', 7, UPPER, LOWER, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('\'', 8, DATE, UPPER, LOWER, EMAIL, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('@', 9, NUMERICAL, DATE, UPPER, LOWER, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        LongerShortString.setUp('|', 10, NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, EUROPEAN, LOWERHEX, UPPERHEX);
        LongerShortString[] retainUri = new LongerShortString[]{NUMERICAL, DATE, UPPER, LOWER, EMAIL, ALPHANUM, ALPHASYM, EUROPEAN, LOWERHEX, UPPERHEX};
        LongerShortString.setUp(';', 11, retainUri);
        LongerShortString.setUp('*', 12, retainUri);
        LongerShortString.setUp('?', 13, retainUri);
        LongerShortString.setUp('&', 14, retainUri);
        LongerShortString.setUp('%', 15, retainUri);
        LongerShortString.setUp('#', 16, retainUri);
        LongerShortString.setUp('(', 17, retainUri);
        LongerShortString.setUp(')', 18, retainUri);
        LongerShortString.setUp('$', 19, retainUri);
        LongerShortString.setUp('<', 20, retainUri);
        LongerShortString.setUp('>', 21, retainUri);
        LongerShortString.setUp('=', 22, retainUri);
        for (c = 'A'; c <= 'F'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, LOWER, EMAIL, URI, LOWERHEX);
        }
        for (c = 'G'; c <= 'Z'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, LOWER, EMAIL, URI, LOWERHEX, UPPERHEX);
        }
        for (c = 'a'; c <= 'f'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, UPPER, UPPERHEX);
        }
        for (c = 'g'; c <= 'z'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, UPPER, UPPERHEX, LOWERHEX);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            LongerShortString.setUp(c, (byte)c, UPPER, LOWER, EMAIL, ALPHASYM);
        }
        for (c = '\u00c0'; c <= '\u00ff'; c = (char)(c + '\u0001')) {
            if (c == 215 || c == 247) continue;
            LongerShortString.setUp(c, (byte)c, NUMERICAL, DATE, UPPER, LOWER, EMAIL, URI, ALPHANUM, ALPHASYM, LOWERHEX, UPPERHEX);
        }
        ENCODINGS_BY_ENCODING = new LongerShortString[ENCODING_COUNT + 2];
        LongerShortString[] longerShortStringArray = ENCODINGS;
        int n = longerShortStringArray.length;
        for (int i = 0; i < n; ++i) {
            LongerShortString encoding;
            LongerShortString.ENCODINGS_BY_ENCODING[encoding.encodingHeader] = encoding = longerShortStringArray[i];
        }
    }
}

