/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class NodeRecord
extends PrimitiveRecord {
    private long nextRel;
    private long labels;
    private Collection<DynamicRecord> dynamicLabelRecords;
    private boolean isLight;
    private boolean dense;

    public NodeRecord(long id2) {
        super(id2);
    }

    public NodeRecord initialize(boolean inUse, long nextProp, boolean dense, long nextRel, long labels2) {
        super.initialize(inUse, nextProp);
        this.nextRel = nextRel;
        this.dense = dense;
        this.labels = labels2;
        this.dynamicLabelRecords = Collections.emptyList();
        this.isLight = true;
        return this;
    }

    @Deprecated
    public NodeRecord(long id2, boolean dense, long nextRel, long nextProp) {
        this(id2, false, dense, nextRel, nextProp, 0L);
    }

    @Deprecated
    public NodeRecord(long id2, boolean inUse, boolean dense, long nextRel, long nextProp, long labels2) {
        super(id2, nextProp);
        this.nextRel = nextRel;
        this.dense = dense;
        this.labels = labels2;
        this.setInUse(inUse);
    }

    @Deprecated
    public NodeRecord(long id2, boolean dense, long nextRel, long nextProp, boolean inUse) {
        this(id2, dense, nextRel, nextProp);
        this.setInUse(inUse);
    }

    @Override
    public void clear() {
        this.initialize(false, Record.NO_NEXT_PROPERTY.intValue(), false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_LABELS_FIELD.intValue());
    }

    public long getNextRel() {
        return this.nextRel;
    }

    public void setNextRel(long nextRel) {
        this.nextRel = nextRel;
    }

    public void setLabelField(long labels2, Collection<DynamicRecord> dynamicRecords) {
        this.labels = labels2;
        this.dynamicLabelRecords = dynamicRecords;
        this.isLight = dynamicRecords.isEmpty();
    }

    public long getLabelField() {
        return this.labels;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public Collection<DynamicRecord> getDynamicLabelRecords() {
        return this.dynamicLabelRecords;
    }

    public Iterable<DynamicRecord> getUsedDynamicLabelRecords() {
        return Iterables.filter(AbstractBaseRecord::inUse, this.dynamicLabelRecords);
    }

    public boolean isDense() {
        return this.dense;
    }

    public void setDense(boolean dense) {
        this.dense = dense;
    }

    public String toString() {
        String denseInfo = (this.dense ? "group" : "rel") + "=" + this.nextRel;
        String lightHeavyInfo = this.isLight ? "light" : (this.dynamicLabelRecords.isEmpty() ? "heavy" : "heavy,dynlabels=" + this.dynamicLabelRecords);
        return "Node[" + this.getId() + ",used=" + this.inUse() + "," + denseInfo + ",prop=" + this.getNextProp() + ",labels=" + NodeLabelsField.parseLabelsField(this) + "," + lightHeavyInfo + ",secondaryUnitId=" + this.getSecondaryUnitId() + "]";
    }

    @Override
    public void setIdTo(PropertyRecord property) {
        property.setNodeId(this.getId());
    }

    @Override
    public NodeRecord clone() {
        NodeRecord clone2 = (NodeRecord)super.clone();
        if (!this.dynamicLabelRecords.isEmpty()) {
            ArrayList<DynamicRecord> clonedLabelRecords = new ArrayList<DynamicRecord>(this.dynamicLabelRecords.size());
            for (DynamicRecord labelRecord : this.dynamicLabelRecords) {
                clonedLabelRecords.add(labelRecord.clone());
            }
            clone2.dynamicLabelRecords = clonedLabelRecords;
        } else {
            clone2.dynamicLabelRecords = Collections.emptyList();
        }
        return clone2;
    }
}

