/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class SchemaRecord
extends AbstractBaseRecord
implements Iterable<DynamicRecord> {
    private Collection<DynamicRecord> records;

    public SchemaRecord(Collection<DynamicRecord> records) {
        super(-1L);
        this.initialize(records);
    }

    public SchemaRecord initialize(Collection<DynamicRecord> records) {
        this.initialize(true);
        Iterator<DynamicRecord> iterator2 = records.iterator();
        long id2 = iterator2.hasNext() ? iterator2.next().getId() : (long)Record.NULL_REFERENCE.intValue();
        this.setId(id2);
        this.records = records;
        return this;
    }

    public void setDynamicRecords(Collection<DynamicRecord> records) {
        this.records.clear();
        this.records.addAll(records);
    }

    @Override
    public void clear() {
        super.clear();
        this.records = null;
    }

    @Override
    public Iterator<DynamicRecord> iterator() {
        return this.records.iterator();
    }

    public int size() {
        return this.records.size();
    }

    @Override
    public SchemaRecord clone() {
        SchemaRecord clone2 = (SchemaRecord)super.clone();
        ArrayList<DynamicRecord> list2 = new ArrayList<DynamicRecord>(this.records.size());
        for (DynamicRecord record : this.records) {
            list2.add(record.clone());
        }
        clone2.records = list2;
        return clone2;
    }
}

