/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.neo4j.helpers.Numbers;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.string.UTF8;

public class SchemaRuleDeserializer2_0to3_1 {
    private static final Long NO_OWNED_INDEX_RULE = null;

    private SchemaRuleDeserializer2_0to3_1() {
    }

    static boolean isLegacySchemaRule(byte schemaRuleType) {
        return schemaRuleType >= 1 && schemaRuleType <= SchemaRule.Kind.values().length;
    }

    static SchemaRule deserialize(long id2, int labelId, byte kindByte, ByteBuffer buffer) throws MalformedSchemaRuleException {
        SchemaRule.Kind kind = SchemaRule.Kind.forId((byte)kindByte);
        try {
            SchemaRule rule = SchemaRuleDeserializer2_0to3_1.newRule(kind, id2, labelId, buffer);
            if (null == rule) {
                throw new MalformedSchemaRuleException(null, "Deserialized null schema rule for id %d with kind %s", new Object[]{id2, kind.name()});
            }
            return rule;
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException((Throwable)e, "Could not deserialize schema rule for id %d with kind %s", new Object[]{id2, kind.name()});
        }
    }

    private static SchemaRule newRule(SchemaRule.Kind kind, long id2, int labelId, ByteBuffer buffer) {
        switch (kind) {
            case INDEX_RULE: {
                return SchemaRuleDeserializer2_0to3_1.readIndexRule(id2, false, labelId, buffer);
            }
            case CONSTRAINT_INDEX_RULE: {
                return SchemaRuleDeserializer2_0to3_1.readIndexRule(id2, true, labelId, buffer);
            }
            case UNIQUENESS_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readUniquenessConstraintRule(id2, labelId, buffer);
            }
            case NODE_PROPERTY_EXISTENCE_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readNodePropertyExistenceConstraintRule(id2, labelId, buffer);
            }
            case RELATIONSHIP_PROPERTY_EXISTENCE_CONSTRAINT: {
                return SchemaRuleDeserializer2_0to3_1.readRelPropertyExistenceConstraintRule(id2, labelId, buffer);
            }
        }
        throw new IllegalArgumentException(kind.name());
    }

    private static StoreIndexDescriptor readIndexRule(long id2, boolean constraintIndex, int label, ByteBuffer serialized) {
        IndexProviderDescriptor providerDescriptor = SchemaRuleDeserializer2_0to3_1.readIndexProviderDescriptor(serialized);
        int[] propertyKeyIds = SchemaRuleDeserializer2_0to3_1.readIndexPropertyKeys(serialized);
        LabelSchemaDescriptor schema = SchemaDescriptorFactory.forLabel(label, propertyKeyIds);
        Optional name = Optional.empty();
        IndexDescriptor descriptor = constraintIndex ? IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, name, (IndexProviderDescriptor)providerDescriptor) : IndexDescriptorFactory.forSchema((SchemaDescriptor)schema, name, (IndexProviderDescriptor)providerDescriptor);
        StoreIndexDescriptor storeIndexDescriptor = constraintIndex ? descriptor.withIds(id2, SchemaRuleDeserializer2_0to3_1.readOwningConstraint(serialized)) : descriptor.withId(id2);
        return storeIndexDescriptor;
    }

    private static IndexProviderDescriptor readIndexProviderDescriptor(ByteBuffer serialized) {
        String providerKey = UTF8.getDecodedStringFrom(serialized);
        String providerVersion = UTF8.getDecodedStringFrom(serialized);
        return new IndexProviderDescriptor(providerKey, providerVersion);
    }

    private static int[] readIndexPropertyKeys(ByteBuffer serialized) {
        int count2 = serialized.getShort();
        assert (count2 >= 1);
        int[] props2 = new int[count2];
        for (int i = 0; i < count2; ++i) {
            props2[i] = Numbers.safeCastLongToInt(serialized.getLong());
        }
        return props2;
    }

    private static long readOwningConstraint(ByteBuffer serialized) {
        return serialized.getLong();
    }

    public static ConstraintRule readUniquenessConstraintRule(long id2, int labelId, ByteBuffer buffer) {
        return new ConstraintRule(id2, ConstraintDescriptorFactory.uniqueForLabel(labelId, SchemaRuleDeserializer2_0to3_1.readConstraintPropertyKeys(buffer)), SchemaRuleDeserializer2_0to3_1.readOwnedIndexRule(buffer));
    }

    public static ConstraintRule readNodePropertyExistenceConstraintRule(long id2, int labelId, ByteBuffer buffer) {
        return new ConstraintRule(id2, ConstraintDescriptorFactory.existsForLabel(labelId, SchemaRuleDeserializer2_0to3_1.readPropertyKey(buffer)), NO_OWNED_INDEX_RULE);
    }

    public static ConstraintRule readRelPropertyExistenceConstraintRule(long id2, int relTypeId, ByteBuffer buffer) {
        return new ConstraintRule(id2, ConstraintDescriptorFactory.existsForRelType(relTypeId, SchemaRuleDeserializer2_0to3_1.readPropertyKey(buffer)), NO_OWNED_INDEX_RULE);
    }

    private static int readPropertyKey(ByteBuffer buffer) {
        return buffer.getInt();
    }

    private static int[] readConstraintPropertyKeys(ByteBuffer buffer) {
        int[] keys = new int[buffer.get()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = Numbers.safeCastLongToInt(buffer.getLong());
        }
        return keys;
    }

    private static Long readOwnedIndexRule(ByteBuffer buffer) {
        return buffer.getLong();
    }
}

