/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.store.record.ConstraintRule;
import org.neo4j.kernel.impl.store.record.SchemaRuleDeserializer2_0to3_1;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.string.UTF8;

public class SchemaRuleSerialization {
    private static final byte INDEX_RULE = 11;
    private static final byte CONSTRAINT_RULE = 12;
    private static final byte GENERAL_INDEX = 31;
    private static final byte UNIQUE_INDEX = 32;
    private static final byte EXISTS_CONSTRAINT = 61;
    private static final byte UNIQUE_CONSTRAINT = 62;
    private static final byte UNIQUE_EXISTS_CONSTRAINT = 63;
    private static final byte SIMPLE_LABEL = 91;
    private static final byte SIMPLE_REL_TYPE = 92;
    private static final byte GENERIC_MULTI_TOKEN_TYPE = 93;
    private static final long NO_OWNING_CONSTRAINT_YET = -1L;
    private static final int LEGACY_LABEL_OR_REL_TYPE_ID = -1;
    private static SchemaComputer<Integer> schemaSizeComputer = new SchemaComputer<Integer>(){

        public Integer computeSpecific(LabelSchemaDescriptor schema) {
            return 7 + 4 * schema.getPropertyIds().length;
        }

        public Integer computeSpecific(RelationTypeSchemaDescriptor schema) {
            return 7 + 4 * schema.getPropertyIds().length;
        }

        public Integer computeSpecific(SchemaDescriptor schema) {
            return 4 + 4 * schema.getEntityTokenIds().length + 2 + 4 * schema.getPropertyIds().length;
        }
    };

    private SchemaRuleSerialization() {
    }

    public static byte[] serialize(SchemaRule schemaRule) {
        if (schemaRule instanceof StoreIndexDescriptor) {
            return SchemaRuleSerialization.serialize((StoreIndexDescriptor)schemaRule);
        }
        if (schemaRule instanceof ConstraintRule) {
            return SchemaRuleSerialization.serialize((ConstraintRule)schemaRule);
        }
        throw new IllegalStateException("Unknown schema rule type: " + schemaRule.getClass());
    }

    public static SchemaRule deserialize(long id2, ByteBuffer source) throws MalformedSchemaRuleException {
        int legacyLabelOrRelTypeId = source.getInt();
        byte schemaRuleType = source.get();
        switch (schemaRuleType) {
            case 11: {
                return SchemaRuleSerialization.readIndexRule(id2, source);
            }
            case 12: {
                return SchemaRuleSerialization.readConstraintRule(id2, source);
            }
        }
        if (SchemaRuleDeserializer2_0to3_1.isLegacySchemaRule(schemaRuleType)) {
            return SchemaRuleDeserializer2_0to3_1.deserialize(id2, legacyLabelOrRelTypeId, schemaRuleType, source);
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown schema rule type '%d'.", schemaRuleType));
    }

    public static byte[] serialize(StoreIndexDescriptor indexDescriptor) {
        ByteBuffer target = ByteBuffer.allocate(SchemaRuleSerialization.lengthOf(indexDescriptor));
        target.putInt(-1);
        target.put((byte)11);
        IndexProviderDescriptor providerDescriptor = indexDescriptor.providerDescriptor();
        UTF8.putEncodedStringInto(providerDescriptor.getKey(), target);
        UTF8.putEncodedStringInto(providerDescriptor.getVersion(), target);
        switch (indexDescriptor.type()) {
            case GENERAL: {
                target.put((byte)31);
                break;
            }
            case UNIQUE: {
                target.put((byte)32);
                Long owningConstraint = indexDescriptor.getOwningConstraint();
                target.putLong(owningConstraint == null ? -1L : owningConstraint);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Got unknown index descriptor type '%s'.", indexDescriptor.type()));
            }
        }
        indexDescriptor.schema().processWith((SchemaProcessor)new SchemaDescriptorSerializer(target));
        UTF8.putEncodedStringInto(indexDescriptor.getName(), target);
        return target.array();
    }

    public static byte[] serialize(ConstraintRule constraintRule) {
        ByteBuffer target = ByteBuffer.allocate(SchemaRuleSerialization.lengthOf(constraintRule));
        target.putInt(-1);
        target.put((byte)12);
        ConstraintDescriptor constraintDescriptor = constraintRule.getConstraintDescriptor();
        switch (constraintDescriptor.type()) {
            case EXISTS: {
                target.put((byte)61);
                break;
            }
            case UNIQUE: {
                target.put((byte)62);
                target.putLong(constraintRule.getOwnedIndex());
                break;
            }
            case UNIQUE_EXISTS: {
                target.put((byte)63);
                target.putLong(constraintRule.getOwnedIndex());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Got unknown index descriptor type '%s'.", constraintDescriptor.type()));
            }
        }
        constraintDescriptor.schema().processWith((SchemaProcessor)new SchemaDescriptorSerializer(target));
        UTF8.putEncodedStringInto(constraintRule.getName(), target);
        return target.array();
    }

    static int lengthOf(StoreIndexDescriptor indexDescriptor) {
        int length2 = 4;
        ++length2;
        IndexProviderDescriptor providerDescriptor = indexDescriptor.providerDescriptor();
        length2 += UTF8.computeRequiredByteBufferSize(providerDescriptor.getKey());
        length2 += UTF8.computeRequiredByteBufferSize(providerDescriptor.getVersion());
        ++length2;
        if (indexDescriptor.type() == IndexDescriptor.Type.UNIQUE) {
            length2 += 8;
        }
        length2 += ((Integer)indexDescriptor.schema().computeWith(schemaSizeComputer)).intValue();
        return length2 += UTF8.computeRequiredByteBufferSize(indexDescriptor.getName());
    }

    static int lengthOf(ConstraintRule constraintRule) {
        int length2 = 4;
        ++length2;
        ++length2;
        ConstraintDescriptor constraintDescriptor = constraintRule.getConstraintDescriptor();
        if (constraintDescriptor.enforcesUniqueness()) {
            length2 += 8;
        }
        length2 += ((Integer)constraintDescriptor.schema().computeWith(schemaSizeComputer)).intValue();
        return length2 += UTF8.computeRequiredByteBufferSize(constraintRule.getName());
    }

    private static StoreIndexDescriptor readIndexRule(long id2, ByteBuffer source) throws MalformedSchemaRuleException {
        IndexProviderDescriptor indexProvider = SchemaRuleSerialization.readIndexProviderDescriptor(source);
        byte indexRuleType = source.get();
        switch (indexRuleType) {
            case 31: {
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                Optional<String> name = SchemaRuleSerialization.readRuleName(source);
                return IndexDescriptorFactory.forSchema((SchemaDescriptor)schema, name, (IndexProviderDescriptor)indexProvider).withId(id2);
            }
            case 32: {
                long owningConstraint = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                Optional<String> name = SchemaRuleSerialization.readRuleName(source);
                IndexDescriptor descriptor = IndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema, name, (IndexProviderDescriptor)indexProvider);
                return owningConstraint == -1L ? descriptor.withId(id2) : descriptor.withIds(id2, owningConstraint);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown index rule type '%d'.", indexRuleType));
    }

    private static IndexProviderDescriptor readIndexProviderDescriptor(ByteBuffer source) {
        String providerKey = UTF8.getDecodedStringFrom(source);
        String providerVersion = UTF8.getDecodedStringFrom(source);
        return new IndexProviderDescriptor(providerKey, providerVersion);
    }

    private static ConstraintRule readConstraintRule(long id2, ByteBuffer source) throws MalformedSchemaRuleException {
        byte constraintRuleType = source.get();
        switch (constraintRuleType) {
            case 61: {
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                String name = SchemaRuleSerialization.readRuleName(source).orElse(null);
                return ConstraintRule.constraintRule(id2, ConstraintDescriptorFactory.existsForSchema(schema), name);
            }
            case 62: {
                long ownedUniqueIndex = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                UniquenessConstraintDescriptor descriptor = ConstraintDescriptorFactory.uniqueForSchema(schema);
                String name = SchemaRuleSerialization.readRuleName(source).orElse(null);
                return ConstraintRule.constraintRule(id2, descriptor, ownedUniqueIndex, name);
            }
            case 63: {
                long ownedNodeKeyIndex = source.getLong();
                SchemaDescriptor schema = SchemaRuleSerialization.readSchema(source);
                NodeKeyConstraintDescriptor nodeKeyConstraintDescriptor = ConstraintDescriptorFactory.nodeKeyForSchema(schema);
                String name = SchemaRuleSerialization.readRuleName(source).orElse(null);
                return ConstraintRule.constraintRule(id2, nodeKeyConstraintDescriptor, ownedNodeKeyIndex, name);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown constraint rule type '%d'.", constraintRuleType));
    }

    private static Optional<String> readRuleName(ByteBuffer source) {
        if (source.remaining() >= 4) {
            String ruleName = UTF8.getDecodedStringFrom(source);
            return ruleName.isEmpty() ? Optional.empty() : Optional.of(ruleName);
        }
        return Optional.empty();
    }

    private static SchemaDescriptor readSchema(ByteBuffer source) throws MalformedSchemaRuleException {
        byte schemaDescriptorType = source.get();
        switch (schemaDescriptorType) {
            case 91: {
                int labelId = source.getInt();
                int[] propertyIds = SchemaRuleSerialization.readTokenIdList(source);
                return SchemaDescriptorFactory.forLabel(labelId, propertyIds);
            }
            case 92: {
                int relTypeId = source.getInt();
                int[] propertyIds = SchemaRuleSerialization.readTokenIdList(source);
                return SchemaDescriptorFactory.forRelType(relTypeId, propertyIds);
            }
            case 93: {
                return SchemaRuleSerialization.readMultiTokenSchema(source);
            }
        }
        throw new MalformedSchemaRuleException(String.format("Got unknown schema descriptor type '%d'.", schemaDescriptorType));
    }

    private static SchemaDescriptor readMultiTokenSchema(ByteBuffer source) throws MalformedSchemaRuleException {
        EntityType type;
        byte schemaDescriptorType = source.get();
        switch (schemaDescriptorType) {
            case 91: {
                type = EntityType.NODE;
                break;
            }
            case 92: {
                type = EntityType.RELATIONSHIP;
                break;
            }
            default: {
                throw new MalformedSchemaRuleException(String.format("Got unknown schema descriptor type '%d'.", schemaDescriptorType));
            }
        }
        int[] entityTokenIds = SchemaRuleSerialization.readTokenIdList(source);
        int[] propertyIds = SchemaRuleSerialization.readTokenIdList(source);
        return SchemaDescriptorFactory.multiToken(entityTokenIds, type, propertyIds);
    }

    private static int[] readTokenIdList(ByteBuffer source) {
        int numProperties = source.getShort();
        int[] propertyIds = new int[numProperties];
        for (int i = 0; i < numProperties; ++i) {
            propertyIds[i] = source.getInt();
        }
        return propertyIds;
    }

    private static class SchemaDescriptorSerializer
    implements SchemaProcessor {
        private final ByteBuffer target;

        SchemaDescriptorSerializer(ByteBuffer target) {
            this.target = target;
        }

        public void processSpecific(LabelSchemaDescriptor schema) {
            this.target.put((byte)91);
            this.target.putInt(schema.getLabelId());
            this.putIds(schema.getPropertyIds());
        }

        public void processSpecific(RelationTypeSchemaDescriptor schema) {
            this.target.put((byte)92);
            this.target.putInt(schema.getRelTypeId());
            this.putIds(schema.getPropertyIds());
        }

        public void processSpecific(SchemaDescriptor schema) {
            this.target.put((byte)93);
            if (schema.entityType() == EntityType.NODE) {
                this.target.put((byte)91);
            } else {
                this.target.put((byte)92);
            }
            this.putIds(schema.getEntityTokenIds());
            this.putIds(schema.getPropertyIds());
        }

        private void putIds(int[] ids) {
            this.target.putShort((short)ids.length);
            for (int entityTokenId : ids) {
                this.target.putInt(entityTokenId);
            }
        }
    }
}

