/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.stream.Streams;

class StoreMigratorFileOperation {
    StoreMigratorFileOperation() {
    }

    static void fileOperation(FileOperation operation, FileSystemAbstraction fs, DatabaseLayout fromLayout, DatabaseLayout toLayout, Iterable<DatabaseFile> databaseFiles, boolean allowSkipNonExistentFiles, ExistingTargetStrategy existingTargetStrategy) throws IOException {
        for (DatabaseFile databaseStore : databaseFiles) {
            File[] files2 = (File[])Stream.concat(fromLayout.file(databaseStore), Streams.ofOptional(fromLayout.idFile(databaseStore))).toArray(File[]::new);
            StoreMigratorFileOperation.perform(operation, fs, fromLayout, toLayout, allowSkipNonExistentFiles, existingTargetStrategy, files2);
        }
    }

    private static void perform(FileOperation operation, FileSystemAbstraction fs, DatabaseLayout fromLayout, DatabaseLayout toLayout, boolean allowSkipNonExistentFiles, ExistingTargetStrategy existingTargetStrategy, File[] files2) throws IOException {
        for (File file : files2) {
            if (file == null) continue;
            operation.perform(fs, file.getName(), fromLayout.databaseDirectory(), allowSkipNonExistentFiles, toLayout.databaseDirectory(), existingTargetStrategy);
        }
    }
}

