/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.Objects;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;

public class SimpleTriggerInfo
implements TriggerInfo {
    private final String triggerName;
    private String description;

    public SimpleTriggerInfo(String triggerName) {
        assert (triggerName != null);
        this.triggerName = triggerName;
    }

    @Override
    public String describe(long transactionId) {
        String info2 = this.description == null ? this.triggerName : this.triggerName + " for " + this.description;
        return "Checkpoint triggered by \"" + info2 + "\" @ txId: " + transactionId;
    }

    @Override
    public void accept(String description) {
        assert (description != null);
        assert (this.description == null);
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTriggerInfo that = (SimpleTriggerInfo)o;
        return Objects.equals(this.triggerName, that.triggerName) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.triggerName, this.description);
    }
}

