/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import java.util.stream.LongStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdConfigParser;
import org.neo4j.util.VisibleForTesting;

public class LogPruneStrategyFactory {
    private static final LogPruneStrategy NO_PRUNING = new LogPruneStrategy(){

        @Override
        public LongStream findLogVersionsToDelete(long upToLogVersion) {
            return LongStream.empty();
        }

        public String toString() {
            return "NO_PRUNING";
        }
    };

    LogPruneStrategy strategyFromConfigValue(FileSystemAbstraction fileSystem, LogFiles logFiles, Clock clock, String configValue) {
        ThresholdConfigParser.ThresholdConfigValue value2 = ThresholdConfigParser.parse(configValue);
        if (value2 == ThresholdConfigParser.ThresholdConfigValue.NO_PRUNING) {
            return NO_PRUNING;
        }
        Threshold thresholdToUse = LogPruneStrategyFactory.getThresholdByType(fileSystem, clock, value2, configValue);
        return new ThresholdBasedPruneStrategy(fileSystem, logFiles, thresholdToUse);
    }

    @VisibleForTesting
    static Threshold getThresholdByType(FileSystemAbstraction fileSystem, Clock clock, ThresholdConfigParser.ThresholdConfigValue value2, String originalConfigValue) {
        long thresholdValue = value2.value;
        switch (value2.type) {
            case "files": {
                return new FileCountThreshold(thresholdValue);
            }
            case "size": {
                return new FileSizeThreshold(fileSystem, thresholdValue);
            }
            case "txs": 
            case "entries": {
                return new EntryCountThreshold(thresholdValue);
            }
            case "hours": {
                return new EntryTimespanThreshold(clock, TimeUnit.HOURS, thresholdValue);
            }
            case "days": {
                return new EntryTimespanThreshold(clock, TimeUnit.DAYS, thresholdValue);
            }
        }
        throw new IllegalArgumentException("Invalid log pruning configuration value '" + originalConfigValue + "'. Invalid type '" + value2.type + "', valid are files, size, txs, entries, hours, days.");
    }
}

