/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public class ReversedMultiFileTransactionCursor
implements TransactionCursor {
    private final LogPosition backToPosition;
    private final ThrowingFunction<LogPosition, TransactionCursor, IOException> cursorFactory;
    private long currentVersion;
    private TransactionCursor currentLogTransactionCursor;

    public static TransactionCursor fromLogFile(LogFiles logFiles, LogFile logFile, LogPosition backToPosition, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) {
        long highestVersion = logFiles.getHighestLogVersion();
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        ThrowingFunction<LogPosition, TransactionCursor, IOException> factory = position2 -> {
            ReadableLogChannel channel = logFile.getReader((LogPosition)position2, LogVersionBridge.NO_MORE_CHANNELS);
            if (channel instanceof ReadAheadLogChannel) {
                return new ReversedSingleFileTransactionCursor((ReadAheadLogChannel)channel, logEntryReader, failOnCorruptedLogFiles, monitor);
            }
            return EagerlyReversedTransactionCursor.eagerlyReverse(new PhysicalTransactionCursor<ReadableLogChannel>(channel, logEntryReader));
        };
        return new ReversedMultiFileTransactionCursor(factory, highestVersion, backToPosition);
    }

    ReversedMultiFileTransactionCursor(ThrowingFunction<LogPosition, TransactionCursor, IOException> cursorFactory, long highestVersion, LogPosition backToPosition) {
        this.cursorFactory = cursorFactory;
        this.backToPosition = backToPosition;
        this.currentVersion = highestVersion + 1L;
    }

    @Override
    public CommittedTransactionRepresentation get() {
        return (CommittedTransactionRepresentation)this.currentLogTransactionCursor.get();
    }

    @Override
    public boolean next() throws IOException {
        while (this.currentLogTransactionCursor == null || !this.currentLogTransactionCursor.next()) {
            --this.currentVersion;
            if (this.currentVersion < this.backToPosition.getLogVersion()) {
                return false;
            }
            this.closeCurrent();
            LogPosition position2 = this.currentVersion > this.backToPosition.getLogVersion() ? LogPosition.start(this.currentVersion) : this.backToPosition;
            this.currentLogTransactionCursor = this.cursorFactory.apply(position2);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.closeCurrent();
    }

    private void closeCurrent() throws IOException {
        if (this.currentLogTransactionCursor != null) {
            this.currentLogTransactionCursor.close();
            this.currentLogTransactionCursor = null;
        }
    }

    @Override
    public LogPosition position() {
        return this.currentLogTransactionCursor.position();
    }
}

