/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.cursor.CursorValue;
import org.neo4j.cursor.RawCursor;

public class Cursors {
    private static Cursor<Object> EMPTY = new Cursor<Object>(){

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public Object get() {
            throw new IllegalStateException("no elements");
        }

        @Override
        public void close() {
        }
    };

    private Cursors() {
    }

    public static <T> Cursor<T> empty() {
        return EMPTY;
    }

    public static <E extends Exception> int count(RawCursor<?, E> cursor) throws E {
        try {
            int count2 = 0;
            while (cursor.next()) {
                ++count2;
            }
            int n = count2;
            return n;
        }
        finally {
            cursor.close();
        }
    }

    public static <T, EX extends Exception> RawCursor<T, EX> rawCursorOf(final T ... values2) {
        return new RawCursor<T, EX>(){
            private int idx;
            private CursorValue<T> current = new CursorValue();

            @Override
            public T get() {
                return this.current.get();
            }

            @Override
            public boolean next() throws Exception {
                if (this.idx >= values2.length) {
                    this.current.invalidate();
                    return false;
                }
                this.current.set(values2[this.idx]);
                ++this.idx;
                return true;
            }

            @Override
            public void close() throws Exception {
                this.idx = values2.length;
                this.current.invalidate();
            }
        };
    }

    public static <T, EX extends Exception> RawCursor<T, EX> rawCursorOf(final Iterable<T> iterable) {
        return new RawCursor<T, EX>(){
            private CursorValue<T> current = new CursorValue();
            private Iterator<T> itr = iterable.iterator();

            @Override
            public T get() {
                return this.current.get();
            }

            @Override
            public boolean next() throws Exception {
                if (this.itr.hasNext()) {
                    this.current.set(this.itr.next());
                    return true;
                }
                this.current.invalidate();
                return false;
            }

            @Override
            public void close() throws Exception {
                this.current.invalidate();
            }
        };
    }
}

