/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class HexPrinter {
    private final PrintStream out;
    private int bytesPerLine;
    private int bytesPerGroup;
    private String byteSeparator;
    private String groupSeparator;
    private int maxLineNumberDigits;
    private String lineNumberPrefix;
    private String lineNumberSuffix;
    private long currentLineNumber;
    private int bytesOnThisLine;
    private static final int DEFAULT_BYTES_PER_GROUP = 8;
    private static final int DEFAULT_GROUPS_PER_LINE = 4;
    private static final int DEFAULT_MAX_LINE_NUMBER_DIGITS = 0;
    private static final String DEFAULT_GROUP_SEPARATOR = "    ";
    private static final String DEFAULT_LINE_NUMBER_PREFIX = "@ ";
    private static final String DEFAULT_LINE_NUMBER_SUFFIX = ": ";
    private static final String DEFAULT_BYTE_SEPARATOR = " ";

    public HexPrinter withBytesPerLine(int bytesPerLine) {
        this.bytesPerLine = bytesPerLine;
        return this;
    }

    public HexPrinter withBytesPerGroup(int bytesPerGroup) {
        this.bytesPerGroup = bytesPerGroup;
        return this;
    }

    public HexPrinter withGroupSeparator(String separator) {
        this.groupSeparator = separator;
        return this;
    }

    public HexPrinter withLineNumberDigits(int maxLineNumberDigits) {
        this.maxLineNumberDigits = maxLineNumberDigits;
        return this;
    }

    public HexPrinter withLineNumberPrefix(String prefix) {
        this.lineNumberPrefix = prefix;
        return this;
    }

    public HexPrinter withLineNumberSuffix(String suffix) {
        this.lineNumberSuffix = suffix;
        return this;
    }

    public HexPrinter withLineNumberOffset(long offset) {
        this.currentLineNumber = offset;
        return this;
    }

    public HexPrinter withByteSeparator(String byteSeparator) {
        this.byteSeparator = byteSeparator;
        return this;
    }

    public HexPrinter withBytesGroupingFormat(int bytesPerLine, int bytesPerGroup, String separator) {
        this.bytesPerLine = bytesPerLine;
        this.bytesPerGroup = bytesPerGroup;
        this.groupSeparator = separator;
        return this;
    }

    public HexPrinter withLineNumberFormat(int maxLineNumberDigits, String prefix, String suffix) {
        this.maxLineNumberDigits = maxLineNumberDigits;
        this.lineNumberPrefix = prefix;
        this.lineNumberSuffix = suffix;
        return this;
    }

    public HexPrinter(PrintStream out) {
        this(out, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public HexPrinter(PrintStream out, int bytesPerGroup, String groupSep) {
        this.out = out;
        this.bytesPerLine = 4 * bytesPerGroup;
        this.bytesPerGroup = bytesPerGroup;
        this.groupSeparator = groupSep;
        this.maxLineNumberDigits = 0;
        this.lineNumberPrefix = DEFAULT_LINE_NUMBER_PREFIX;
        this.lineNumberSuffix = DEFAULT_LINE_NUMBER_SUFFIX;
        this.byteSeparator = DEFAULT_BYTE_SEPARATOR;
    }

    public HexPrinter append(byte value2) {
        this.checkNewLine();
        this.addHexValue(value2);
        return this;
    }

    public HexPrinter append(ReadableByteChannel source) throws IOException {
        return this.append(source, -1);
    }

    public HexPrinter append(ReadableByteChannel source, int atMost) throws IOException {
        boolean indefinite = atMost == -1;
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        block0: while (true) {
            int read;
            buffer.clear();
            if (!indefinite) {
                buffer.limit(Math.min(buffer.capacity(), atMost));
            }
            if ((read = source.read(buffer)) == -1) break;
            atMost -= read;
            buffer.flip();
            while (true) {
                if (!buffer.hasRemaining()) continue block0;
                this.append(buffer.get());
            }
            break;
        }
        return this;
    }

    public HexPrinter append(ByteBuffer bytes2, int offset, int length2) {
        for (int i = offset; i < offset + length2; ++i) {
            this.append(bytes2.get(i));
        }
        return this;
    }

    public HexPrinter append(ByteBuffer bytes2) {
        return this.append(bytes2, bytes2.position(), bytes2.remaining());
    }

    public HexPrinter append(byte[] bytes2) {
        return this.append(ByteBuffer.wrap(bytes2), 0, bytes2.length);
    }

    private void addHexValue(byte value2) {
        if (this.bytesOnThisLine != 1) {
            if (this.bytesOnThisLine % this.bytesPerGroup == 1) {
                this.out.append(this.groupSeparator);
            } else {
                this.out.append(this.byteSeparator);
            }
        }
        this.out.printf("%X%X", 0xF & value2 >> 4, 0xF & value2);
    }

    private void checkNewLine() {
        if (this.bytesOnThisLine >= this.bytesPerLine) {
            this.out.println();
            this.bytesOnThisLine = 0;
            ++this.currentLineNumber;
        }
        if (this.bytesOnThisLine == 0 && this.maxLineNumberDigits > 0) {
            this.out.append(this.lineNumberPrefix);
            this.out.printf("0x%0" + this.maxLineNumberDigits + "X", this.currentLineNumber);
            this.out.append(this.lineNumberSuffix);
        }
        ++this.bytesOnThisLine;
    }

    public static String hex(ByteBuffer bytes2, int offset, int length2) {
        return HexPrinter.hex(bytes2, offset, length2, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public static String hex(ByteBuffer bytes2, int offset, int length2, int bytesPerBlock, String groupSep) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outStream);
        new HexPrinter(out, bytesPerBlock, groupSep).append(bytes2, offset, length2);
        out.flush();
        return outStream.toString();
    }

    public static String hex(ByteBuffer bytes2) {
        return HexPrinter.hex(bytes2, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public static String hex(ByteBuffer bytes2, int bytesPerBlock, String groupSep) {
        return HexPrinter.hex(bytes2, bytes2.position(), bytes2.limit(), bytesPerBlock, groupSep);
    }

    public static String hex(byte[] bytes2) {
        return HexPrinter.hex(bytes2, 8, DEFAULT_GROUP_SEPARATOR);
    }

    public static String hex(byte[] bytes2, int bytesPerBlock, String groupSep) {
        return HexPrinter.hex(ByteBuffer.wrap(bytes2), bytesPerBlock, groupSep);
    }

    public static String hex(byte b) {
        return String.format("%02X", b);
    }
}

