/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Arrays;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.collections.api.iterator.IntIterator;

public class SimpleBitSet
extends StampedLock {
    private long lastCheckPointKey;
    private long[] data;

    public SimpleBitSet(int size2) {
        int capacity;
        int initialCapacity = size2 / 64;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        long stamp = this.writeLock();
        this.data = new long[capacity];
        this.unlockWrite(stamp);
    }

    public boolean contains(int key) {
        boolean result2;
        long stamp;
        int idx = key >>> 6;
        do {
            stamp = this.tryOptimisticRead();
            boolean bl = result2 = this.data.length > idx && (this.data[idx] & 1L << (key & 0x3F)) != 0L;
        } while (!this.validate(stamp));
        return result2;
    }

    public void put(int key) {
        long stamp = this.writeLock();
        int idx = key >>> 6;
        this.ensureCapacity(idx);
        this.data[idx] = this.data[idx] | 1L << (key & 0x3F);
        this.unlockWrite(stamp);
    }

    public void put(SimpleBitSet other2) {
        long stamp = this.writeLock();
        this.ensureCapacity(other2.data.length - 1);
        for (int i = 0; i < this.data.length && i < other2.data.length; ++i) {
            this.data[i] = this.data[i] | other2.data[i];
        }
        this.unlockWrite(stamp);
    }

    public void remove(int key) {
        long stamp = this.writeLock();
        int idx = key >>> 6;
        if (this.data.length > idx) {
            this.data[idx] = this.data[idx] & (1L << (key & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.unlockWrite(stamp);
    }

    public void remove(SimpleBitSet other2) {
        long stamp = this.writeLock();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = this.data[i] & (other2.data[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.unlockWrite(stamp);
    }

    public long checkPointAndPut(long checkPoint, int key) {
        if (!this.validate(checkPoint) || (long)key != this.lastCheckPointKey) {
            long stamp = this.writeLock();
            int idx = key >>> 6;
            if (idx < this.data.length) {
                Arrays.fill(this.data, 0L);
            } else {
                int len = this.data.length;
                len = this.findNewLength(idx, len);
                this.data = new long[len];
            }
            this.data[idx] = this.data[idx] | 1L << (key & 0x3F);
            this.lastCheckPointKey = key;
            checkPoint = this.tryConvertToOptimisticRead(stamp);
        }
        return checkPoint;
    }

    private int findNewLength(int idx, int len) {
        while (len <= idx) {
            len *= 2;
        }
        return len;
    }

    public int size() {
        int size2 = 0;
        for (long s2 : this.data) {
            size2 += Long.bitCount(s2);
        }
        return size2;
    }

    private void ensureCapacity(int arrayIndex) {
        this.data = Arrays.copyOf(this.data, this.findNewLength(arrayIndex, this.data.length));
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int next;
            private final int size;
            {
                this.size = SimpleBitSet.this.data.length * 64;
                while (this.next < this.size && !SimpleBitSet.this.contains(this.next)) {
                    ++this.next;
                }
            }

            public boolean hasNext() {
                return this.next < this.size;
            }

            public int next() {
                int current = this.next++;
                while (this.next < this.size && !SimpleBitSet.this.contains(this.next)) {
                    ++this.next;
                }
                return current;
            }
        };
    }
}

