/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import javax.annotation.Nonnull;
import org.neo4j.driver.v1.Config;

public class ConnectionConfig {
    private final String scheme;
    private final String host;
    private final int port;
    private final Config.EncryptionLevel encryption;
    private String username;
    private String password;

    public ConnectionConfig(@Nonnull String scheme, @Nonnull String host, int port, @Nonnull String username, @Nonnull String password, boolean encryption) {
        this.host = host;
        this.port = port;
        this.username = ConnectionConfig.fallbackToEnvVariable(username, "NEO4J_USERNAME");
        this.password = ConnectionConfig.fallbackToEnvVariable(password, "NEO4J_PASSWORD");
        this.encryption = encryption ? Config.EncryptionLevel.REQUIRED : Config.EncryptionLevel.NONE;
        this.scheme = scheme;
    }

    @Nonnull
    static String fallbackToEnvVariable(@Nonnull String preferredValue, @Nonnull String fallbackEnvVar) {
        String result2 = System.getenv(fallbackEnvVar);
        if (result2 == null || !preferredValue.isEmpty()) {
            result2 = preferredValue;
        }
        return result2;
    }

    @Nonnull
    public String scheme() {
        return this.scheme;
    }

    @Nonnull
    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    @Nonnull
    public String username() {
        return this.username;
    }

    @Nonnull
    public String password() {
        return this.password;
    }

    @Nonnull
    public String driverUrl() {
        return String.format("%s%s:%d", this.scheme(), this.host(), this.port());
    }

    @Nonnull
    public Config.EncryptionLevel encryption() {
        return this.encryption;
    }

    public void setUsername(@Nonnull String username) {
        this.username = username;
    }

    public void setPassword(@Nonnull String password) {
        this.password = password;
    }
}

