/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.cypher.internal.evaluator.EvaluationException;
import org.neo4j.cypher.internal.evaluator.Evaluator;
import org.neo4j.cypher.internal.evaluator.ExpressionEvaluator;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.Connector;
import org.neo4j.shell.ParameterMap;
import org.neo4j.shell.StatementExecuter;
import org.neo4j.shell.TransactionHandler;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandExecutable;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;
import org.neo4j.shell.prettyprint.CypherVariablesFormatter;
import org.neo4j.shell.prettyprint.LinePrinter;
import org.neo4j.shell.prettyprint.PrettyConfig;
import org.neo4j.shell.prettyprint.PrettyPrinter;
import org.neo4j.shell.state.BoltResult;
import org.neo4j.shell.state.BoltStateHandler;
import org.neo4j.shell.state.ParamValue;

public class CypherShell
implements StatementExecuter,
Connector,
TransactionHandler,
ParameterMap {
    protected static final Pattern cmdNamePattern = Pattern.compile("^\\s*(?<name>[^\\s]+)\\b(?<args>.*)\\s*$");
    protected final Map<String, ParamValue> queryParams = new HashMap<String, ParamValue>();
    private final LinePrinter linePrinter;
    private final BoltStateHandler boltStateHandler;
    private final PrettyPrinter prettyPrinter;
    private CommandHelper commandHelper;
    private ExpressionEvaluator evaluator = Evaluator.expressionEvaluator();

    public CypherShell(@Nonnull LinePrinter linePrinter, @Nonnull PrettyConfig prettyConfig) {
        this(linePrinter, new BoltStateHandler(), new PrettyPrinter(prettyConfig));
    }

    protected CypherShell(@Nonnull LinePrinter linePrinter, @Nonnull BoltStateHandler boltStateHandler, @Nonnull PrettyPrinter prettyPrinter) {
        this.linePrinter = linePrinter;
        this.boltStateHandler = boltStateHandler;
        this.prettyPrinter = prettyPrinter;
        this.addRuntimeHookToResetShell();
    }

    protected static String stripTrailingSemicolons(@Nonnull String text) {
        int end;
        for (end = text.length(); end > 0 && text.substring(0, end).endsWith(";"); --end) {
        }
        return text.substring(0, end);
    }

    @Override
    public void execute(@Nonnull String cmdString) throws ExitException, CommandException {
        Optional<CommandExecutable> cmd = this.getCommandExecutable(cmdString);
        if (cmd.isPresent()) {
            this.executeCmd(cmd.get());
            return;
        }
        if (!this.isConnected()) {
            throw new CommandException("Not connected to Neo4j");
        }
        this.executeCypher(cmdString);
    }

    private void executeCypher(@Nonnull String cypher) throws CommandException {
        Optional<BoltResult> result2 = this.boltStateHandler.runCypher(cypher, this.allParameterValues());
        result2.ifPresent(boltResult -> this.prettyPrinter.format((BoltResult)boltResult, this.linePrinter));
    }

    @Override
    public boolean isConnected() {
        return this.boltStateHandler.isConnected();
    }

    @Nonnull
    protected Optional<CommandExecutable> getCommandExecutable(@Nonnull String line) {
        Matcher m = cmdNamePattern.matcher(line);
        if (this.commandHelper == null || !m.matches()) {
            return Optional.empty();
        }
        String name = m.group("name");
        String args = m.group("args");
        Command cmd = this.commandHelper.getCommand(name);
        if (cmd == null) {
            return Optional.empty();
        }
        return Optional.of(() -> cmd.execute(CypherShell.stripTrailingSemicolons(args)));
    }

    protected void executeCmd(@Nonnull CommandExecutable cmdExe) throws ExitException, CommandException {
        cmdExe.execute();
    }

    @Override
    public void connect(@Nonnull ConnectionConfig connectionConfig) throws CommandException {
        this.boltStateHandler.connect(connectionConfig);
    }

    @Override
    @Nonnull
    public String getServerVersion() {
        return this.boltStateHandler.getServerVersion();
    }

    @Override
    public void beginTransaction() throws CommandException {
        this.boltStateHandler.beginTransaction();
    }

    @Override
    public Optional<List<BoltResult>> commitTransaction() throws CommandException {
        Optional<List<BoltResult>> results = this.boltStateHandler.commitTransaction();
        results.ifPresent(boltResult -> boltResult.forEach(result2 -> this.prettyPrinter.format((BoltResult)result2, this.linePrinter)));
        return results;
    }

    @Override
    public void rollbackTransaction() throws CommandException {
        this.boltStateHandler.rollbackTransaction();
    }

    @Override
    public boolean isTransactionOpen() {
        return this.boltStateHandler.isTransactionOpen();
    }

    @Override
    @Nonnull
    public Object setParameter(@Nonnull String name, @Nonnull String valueString) throws CommandException {
        try {
            String parameterName = CypherVariablesFormatter.unescapedCypherVariable(name);
            Object value2 = this.evaluator.evaluate(valueString, Object.class);
            this.queryParams.put(parameterName, new ParamValue(valueString, value2));
            return value2;
        }
        catch (EvaluationException e) {
            throw new CommandException(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public Map<String, Object> allParameterValues() {
        return this.queryParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, value2 -> ((ParamValue)value2.getValue()).getValue()));
    }

    @Override
    @Nonnull
    public Map<String, ParamValue> getAllAsUserInput() {
        return this.queryParams;
    }

    void setCommandHelper(@Nonnull CommandHelper commandHelper) {
        this.commandHelper = commandHelper;
    }

    @Override
    public void reset() {
        this.boltStateHandler.reset();
    }

    protected void addRuntimeHookToResetShell() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::reset));
    }
}

