/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.internal.CLibrary;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.exception.AnsiFormattedException;
import org.neo4j.shell.log.AnsiFormattedText;
import org.neo4j.shell.log.Logger;

public class AnsiLogger
implements Logger {
    private final PrintStream out;
    private final PrintStream err;
    private final boolean debug;
    private Format format;

    public AnsiLogger(boolean debug) {
        this(debug, Format.VERBOSE, System.out, System.err);
    }

    public AnsiLogger(boolean debug, @Nonnull Format format2, @Nonnull PrintStream out, @Nonnull PrintStream err) {
        this.debug = debug;
        this.format = format2;
        this.out = out;
        this.err = err;
        try {
            if (AnsiLogger.isOutputInteractive()) {
                Ansi.setEnabled(true);
                AnsiConsole.systemInstall();
            } else {
                Ansi.setEnabled(false);
            }
        }
        catch (Throwable t) {
            Ansi.setEnabled(false);
        }
    }

    @Nonnull
    private static Throwable getRootCause(@Nonnull Throwable th) {
        Throwable cause = th;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    private static boolean isOutputInteractive() {
        return 1 == CLibrary.isatty(CLibrary.STDOUT_FILENO) && 1 == CLibrary.isatty(CLibrary.STDERR_FILENO);
    }

    @Override
    @Nonnull
    public PrintStream getOutputStream() {
        return this.out;
    }

    @Override
    @Nonnull
    public PrintStream getErrorStream() {
        return this.err;
    }

    @Override
    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@Nonnull Format format2) {
        this.format = format2;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public void printError(@Nonnull Throwable throwable) {
        this.printError(this.getFormattedMessage(throwable));
    }

    @Override
    public void printError(@Nonnull String s2) {
        this.err.println(Ansi.ansi().render(s2).toString());
    }

    @Override
    public void printOut(@Nonnull String msg) {
        this.out.println(Ansi.ansi().render(msg).toString());
    }

    @Nonnull
    String getFormattedMessage(@Nonnull Throwable e) {
        AnsiFormattedText msg = AnsiFormattedText.s().colorRed();
        if (this.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            e.printStackTrace(ps);
            msg.append(new String(baos.toByteArray(), StandardCharsets.UTF_8));
        } else {
            Throwable cause = AnsiLogger.getRootCause(e);
            msg = cause instanceof AnsiFormattedException ? msg.append(((AnsiFormattedException)cause).getFormattedMessage()) : (cause instanceof ClientException && cause.getMessage() != null && cause.getMessage().contains("Missing username") ? msg.append(cause.getMessage()).append("\nPlease specify --username, and optionally --password, as argument(s)").append("\nor as environment variable(s), NEO4J_USERNAME, and NEO4J_PASSWORD respectively.").append("\nSee --help for more info.") : (cause.getMessage() != null ? msg.append(cause.getMessage()) : msg.append(cause.getClass().getSimpleName())));
        }
        return msg.formattedString();
    }
}

