/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

public class Utils {
    public static boolean unsignedCompare(long dataA, long dataB, CompareType compareType) {
        switch (compareType) {
            case EQ: {
                return dataA == dataB;
            }
            case GE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case GT: {
                return dataA < dataB == (dataA < 0L != dataB < 0L);
            }
            case LE: {
                if (dataA == dataB) {
                    return true;
                }
            }
            case LT: {
                return dataA < dataB ^ dataA < 0L != dataB < 0L;
            }
            case NE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown compare type: " + (Object)((Object)compareType));
    }

    public static CompareType unsignedDifference(long dataA, long dataB) {
        if (dataA == dataB) {
            return CompareType.EQ;
        }
        return dataA < dataB ^ dataA < 0L != dataB < 0L ? CompareType.LT : CompareType.GT;
    }

    public static boolean anyIdCollides(long[] first, int firstLength, long[] other2, int otherLength) {
        int f = 0;
        int o = 0;
        while (f < firstLength && o < otherLength) {
            if (first[f] == other2[o]) {
                return true;
            }
            if (first[f] < other2[o]) {
                while (++f < firstLength && first[f] < other2[o]) {
                }
                continue;
            }
            while (++o < otherLength && first[f] > other2[o]) {
            }
        }
        return false;
    }

    public static void mergeSortedInto(long[] values2, long[] into, int intoLengthBefore) {
        int v = values2.length - 1;
        int i = intoLengthBefore - 1;
        int t = i + values2.length;
        while (v >= 0 || i >= 0) {
            if (i == -1) {
                into[t--] = values2[v--];
                continue;
            }
            if (v == -1) {
                into[t--] = into[i--];
                continue;
            }
            if (values2[v] >= into[i]) {
                into[t--] = values2[v--];
                continue;
            }
            into[t--] = into[i--];
        }
    }

    private Utils() {
    }

    public static enum CompareType {
        EQ,
        GT,
        GE,
        LT,
        LE,
        NE;

    }
}

