/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.DynamicNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class DynamicLongArray
extends DynamicNumberArray<LongArray>
implements LongArray {
    private final long defaultValue;

    public DynamicLongArray(NumberArrayFactory factory, long chunkSize, long defaultValue) {
        super(factory, chunkSize, (NumberArray[])new LongArray[0]);
        this.defaultValue = defaultValue;
    }

    @Override
    public long get(long index) {
        LongArray chunk = (LongArray)this.chunkOrNullAt(index);
        return chunk != null ? chunk.get(index) : this.defaultValue;
    }

    @Override
    public void set(long index, long value2) {
        ((LongArray)this.at(index)).set(index, value2);
    }

    @Override
    protected LongArray addChunk(long chunkSize, long base) {
        return this.factory.newLongArray(chunkSize, this.defaultValue, base);
    }
}

