/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class OffHeapByteArray
extends OffHeapNumberArray<ByteArray>
implements ByteArray {
    private final byte[] defaultValue;

    protected OffHeapByteArray(long length2, byte[] defaultValue, long base, MemoryAllocationTracker allocationTracker) {
        super(length2, defaultValue.length, base, allocationTracker);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public void swap(long fromIndex, long toIndex) {
        int chunkSize;
        long fromAddress = this.address(fromIndex, 0);
        long toAddress = this.address(toIndex, 0);
        for (int bytesLeft = this.itemSize; bytesLeft > 0; bytesLeft -= chunkSize) {
            if (bytesLeft >= 8) {
                chunkSize = 8;
                long intermediary = this.getLong(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                this.putLong(toAddress, intermediary);
            } else if (bytesLeft >= 4) {
                chunkSize = 4;
                int intermediary = this.getInt(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                this.putInt(toAddress, intermediary);
            } else if (bytesLeft >= 2) {
                chunkSize = 2;
                short intermediary = this.getShort(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                this.putShort(toAddress, intermediary);
            } else {
                chunkSize = 1;
                byte intermediary = this.getByte(fromAddress);
                UnsafeUtil.copyMemory((long)toAddress, (long)fromAddress, (long)chunkSize);
                this.putByte(toAddress, intermediary);
            }
            fromAddress += (long)chunkSize;
            toAddress += (long)chunkSize;
        }
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory((long)this.address, (long)(this.length * (long)this.itemSize), (byte)this.defaultValue[0]);
        } else {
            long intermediary = UnsafeUtil.allocateMemory((long)this.itemSize, (MemoryAllocationTracker)this.allocationTracker);
            for (int i = 0; i < this.defaultValue.length; ++i) {
                UnsafeUtil.putByte((long)(intermediary + (long)i), (byte)this.defaultValue[i]);
            }
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.copyMemory((long)intermediary, (long)adr, (long)this.itemSize);
                ++i;
                adr += (long)this.itemSize;
            }
            UnsafeUtil.free((long)intermediary, (long)this.itemSize, (MemoryAllocationTracker)this.allocationTracker);
        }
    }

    private boolean isByteUniform(byte[] bytes2) {
        byte reference = bytes2[0];
        for (int i = 1; i < bytes2.length; ++i) {
            if (reference == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void get(long index, byte[] into) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            into[i] = UnsafeUtil.getByte((long)address);
            ++i;
            ++address;
        }
    }

    @Override
    public byte getByte(long index, int offset) {
        return UnsafeUtil.getByte((long)this.address(index, offset));
    }

    private byte getByte(long p) {
        return UnsafeUtil.getByte((long)p);
    }

    @Override
    public short getShort(long index, int offset) {
        return this.getShort(this.address(index, offset));
    }

    private short getShort(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            return UnsafeUtil.getShort((long)p);
        }
        return UnsafeUtil.getShortByteWiseLittleEndian((long)p);
    }

    @Override
    public int getInt(long index, int offset) {
        return this.getInt(this.address(index, offset));
    }

    private int getInt(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            return UnsafeUtil.getInt((long)p);
        }
        return UnsafeUtil.getIntByteWiseLittleEndian((long)p);
    }

    @Override
    public long get5ByteLong(long index, int offset) {
        long high1b;
        long address = this.address(index, offset);
        long low4b = (long)this.getInt(address) & 0xFFFFFFFFL;
        long result2 = low4b | (high1b = (long)(UnsafeUtil.getByte((long)(address + 4L)) & 0xFF)) << 32;
        return result2 == 0xFFFFFFFFFFL ? -1L : result2;
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        long high2b;
        long address = this.address(index, offset);
        long low4b = (long)this.getInt(address) & 0xFFFFFFFFL;
        long result2 = low4b | (high2b = (long)(this.getShort(address + 4L) & 0xFFFF)) << 32;
        return result2 == 0xFFFFFFFFFFFFL ? -1L : result2;
    }

    @Override
    public long getLong(long index, int offset) {
        long p = this.address(index, offset);
        return this.getLong(p);
    }

    private long getLong(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            return UnsafeUtil.getLong((long)p);
        }
        return UnsafeUtil.getLongByteWiseLittleEndian((long)p);
    }

    @Override
    public void set(long index, byte[] value2) {
        long address = this.address(index, 0);
        int i = 0;
        while (i < this.itemSize) {
            UnsafeUtil.putByte((long)address, (byte)value2[i]);
            ++i;
            ++address;
        }
    }

    @Override
    public void setByte(long index, int offset, byte value2) {
        UnsafeUtil.putByte((long)this.address(index, offset), (byte)value2);
    }

    private void putByte(long p, byte value2) {
        UnsafeUtil.putByte((long)p, (byte)value2);
    }

    @Override
    public void setShort(long index, int offset, short value2) {
        this.putShort(this.address(index, offset), value2);
    }

    private void putShort(long p, short value2) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putShort((long)p, (short)value2);
        } else {
            UnsafeUtil.putShortByteWiseLittleEndian((long)p, (short)value2);
        }
    }

    @Override
    public void setInt(long index, int offset, int value2) {
        this.putInt(this.address(index, offset), value2);
    }

    private void putInt(long p, int value2) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putInt((long)p, (int)value2);
        } else {
            UnsafeUtil.putIntByteWiseLittleEndian((long)p, (int)value2);
        }
    }

    @Override
    public void set5ByteLong(long index, int offset, long value2) {
        long address = this.address(index, offset);
        this.putInt(address, (int)value2);
        UnsafeUtil.putByte((long)(address + 4L), (byte)((byte)(value2 >>> 32)));
    }

    @Override
    public void set6ByteLong(long index, int offset, long value2) {
        long address = this.address(index, offset);
        this.putInt(address, (int)value2);
        this.putShort(address + 4L, (short)(value2 >>> 32));
    }

    @Override
    public void setLong(long index, int offset, long value2) {
        long p = this.address(index, offset);
        this.putLong(p, value2);
    }

    private void putLong(long p, long value2) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putLong((long)p, (long)value2);
        } else {
            UnsafeUtil.putLongByteWiseLittleEndian((long)p, (long)value2);
        }
    }

    @Override
    public int get3ByteInt(long index, int offset) {
        int highByte;
        long address = this.address(index, offset);
        int lowWord = UnsafeUtil.getShort((long)address) & 0xFFFF;
        int result2 = lowWord | (highByte = UnsafeUtil.getByte((long)(address + 2L)) & 0xFF) << 16;
        return result2 == 0xFFFFFF ? -1 : result2;
    }

    @Override
    public void set3ByteInt(long index, int offset, int value2) {
        long address = this.address(index, offset);
        UnsafeUtil.putShort((long)address, (short)((short)value2));
        UnsafeUtil.putByte((long)(address + 2L), (byte)((byte)(value2 >>> 16)));
    }

    private long address(long index, int offset) {
        this.checkBounds(index);
        return this.address + this.rebase(index) * (long)this.itemSize + (long)offset;
    }

    private void checkBounds(long index) {
        long rebased = this.rebase(index);
        if (rebased < 0L || rebased >= this.length) {
            throw new IndexOutOfBoundsException("Wanted to access " + rebased + " but range is " + this.base + "-" + this.length);
        }
    }
}

