/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.batchimport.cache.BaseNumberArray;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public abstract class OffHeapNumberArray<N extends NumberArray<N>>
extends BaseNumberArray<N> {
    private final long allocatedAddress;
    protected final long address;
    protected final long length;
    protected final MemoryAllocationTracker allocationTracker;
    private final long allocatedBytes;
    private boolean closed;

    protected OffHeapNumberArray(long length2, int itemSize, long base, MemoryAllocationTracker allocationTracker) {
        super(itemSize, base);
        boolean itemSizeIsPowerOfTwo;
        UnsafeUtil.assertHasUnsafe();
        this.length = length2;
        this.allocationTracker = allocationTracker;
        long dataSize = length2 * (long)itemSize;
        boolean bl = itemSizeIsPowerOfTwo = Integer.bitCount(itemSize) == 1;
        if (UnsafeUtil.allowUnalignedMemoryAccess || !itemSizeIsPowerOfTwo) {
            this.allocatedBytes = dataSize;
            this.allocatedAddress = this.address = UnsafeUtil.allocateMemory((long)this.allocatedBytes, (MemoryAllocationTracker)allocationTracker);
        } else {
            this.allocatedBytes = dataSize + (long)itemSize - 1L;
            this.allocatedAddress = UnsafeUtil.allocateMemory((long)this.allocatedBytes, (MemoryAllocationTracker)allocationTracker);
            this.address = UnsafeUtil.alignedMemory((long)this.allocatedAddress, (int)itemSize);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.allocatedBytes);
    }

    @Override
    public void close() {
        if (!this.closed) {
            if (this.length > 0L) {
                UnsafeUtil.free((long)this.allocatedAddress, (long)this.allocatedBytes, (MemoryAllocationTracker)this.allocationTracker);
            }
            this.closed = true;
        }
    }
}

