/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;

public abstract class PageCacheNumberArray<N extends NumberArray<N>>
implements NumberArray<N> {
    protected final PagedFile pagedFile;
    protected final int entriesPerPage;
    protected final int entrySize;
    private final long length;
    private final long defaultValue;
    private final long base;
    private boolean closed;

    PageCacheNumberArray(PagedFile pagedFile, int entrySize, long length2, long base) throws IOException {
        this(pagedFile, entrySize, length2, 0L, base);
    }

    PageCacheNumberArray(PagedFile pagedFile, int entrySize, long length2, long defaultValue, long base) throws IOException {
        this.pagedFile = pagedFile;
        this.entrySize = entrySize;
        this.entriesPerPage = pagedFile.pageSize() / entrySize;
        this.length = length2;
        this.defaultValue = defaultValue;
        this.base = base;
        try (PageCursor cursorToSetLength = pagedFile.io(0L, 2);){
            this.setLength(cursorToSetLength, length2);
        }
        if (defaultValue != 0L) {
            this.setDefaultValue(defaultValue);
        }
    }

    private void setLength(PageCursor cursor, long length2) throws IOException {
        if (!cursor.next((length2 - 1L) / (long)this.entriesPerPage)) {
            throw new IllegalStateException(String.format("Unable to extend the backing file %s to desired size %d.", this.pagedFile, length2));
        }
    }

    protected long pageId(long index) {
        return this.rebase(index) / (long)this.entriesPerPage;
    }

    protected int offset(long index) {
        return Math.toIntExact(this.rebase(index) % (long)this.entriesPerPage * (long)this.entrySize);
    }

    private long rebase(long index) {
        return index - this.base;
    }

    protected void setDefaultValue(long defaultValue) throws IOException {
        block25: {
            try (PageCursor writeCursor = this.pagedFile.io(0L, 6);){
                writeCursor.next();
                int pageSize = this.pagedFile.pageSize();
                this.fillPageWithDefaultValue(writeCursor, defaultValue, pageSize);
                if (this.pageId(this.length - 1L) <= 0L) break block25;
                try (PageCursor cursor = this.pagedFile.io(1L, 6);){
                    while (cursor.next()) {
                        writeCursor.copyTo(0, cursor, 0, pageSize);
                        this.checkBounds(writeCursor);
                    }
                }
            }
        }
    }

    protected void fillPageWithDefaultValue(PageCursor writeCursor, long defaultValue, int pageSize) {
        int longsInPage = pageSize / 8;
        for (int i = 0; i < longsInPage; ++i) {
            writeCursor.putLong(defaultValue);
        }
        this.checkBounds(writeCursor);
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void clear() {
        try {
            this.setDefaultValue(this.defaultValue);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.pagedFile.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public N at(long index) {
        return (N)this;
    }

    @Override
    public void acceptMemoryStatsVisitor(MemoryStatsVisitor visitor) {
        visitor.offHeapUsage(this.length() * (long)this.entrySize);
    }

    protected void checkBounds(PageCursor cursor) {
        if (cursor.checkAndClearBoundsFlag()) {
            throw new IllegalStateException(String.format("Cursor %s access out of bounds, page id %d, offset %d", cursor.toString(), cursor.getCurrentPageId(), cursor.getOffset()));
        }
    }
}

