/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;

public class StringEncoder
implements Encoder {
    private static final long UPPER_INT_MASK = 0xFFFFFFFFL;
    private static final int FOURTH_BYTE = 255;
    private final int numCodes;
    private static final int encodingThreshold = 7;
    private final byte[] reMap = new byte[256];
    private int numChars;

    public StringEncoder() {
        this(2);
    }

    public StringEncoder(int codingStrength) {
        this.numCodes = codingStrength > 2 ? codingStrength : 2;
        Arrays.fill(this.reMap, (byte)-1);
    }

    @Override
    public long encode(Object s2) {
        int[] val = this.encodeInt((String)s2);
        return (long)val[0] << 32 | (long)val[1] & 0xFFFFFFFFL;
    }

    private int[] encodeInt(String s2) {
        int inputLength = s2.length();
        byte[] bytes2 = new byte[inputLength];
        for (int i = 0; i < inputLength; ++i) {
            bytes2[i] = (byte)(s2.charAt(i) % 127);
        }
        this.reMap(bytes2, inputLength);
        if (inputLength <= 7) {
            return this.simplestCode(bytes2, inputLength);
        }
        int[] codes = new int[this.numCodes];
        for (int i = 0; i < this.numCodes; i += 2) {
            codes[i] = this.getCode(bytes2, inputLength, 1);
            codes[i + 1] = this.getCode(bytes2, inputLength, inputLength - 1);
        }
        int carryOver = this.lengthEncoder(inputLength) << 1;
        int temp = 0;
        for (int i = 0; i < this.numCodes; ++i) {
            temp = codes[i] & 0xFF;
            codes[i] = codes[i] >>> 8 | carryOver << 24;
            carryOver = temp;
        }
        return codes;
    }

    private int lengthEncoder(int length2) {
        if (length2 < 32) {
            return length2;
        }
        if (length2 <= 96) {
            return length2 >> 1;
        }
        if (length2 <= 324) {
            return length2 >> 2;
        }
        if (length2 <= 580) {
            return length2 >> 3;
        }
        if (length2 <= 836) {
            return length2 >> 4;
        }
        return 127;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reMap(byte[] bytes2, int inputLength) {
        for (int i = 0; i < inputLength; ++i) {
            if (this.reMap[bytes2[i]] == -1) {
                StringEncoder stringEncoder = this;
                synchronized (stringEncoder) {
                    if (this.reMap[bytes2[i]] == -1) {
                        this.reMap[bytes2[i]] = (byte)(this.numChars++ % 256);
                    }
                }
            }
            bytes2[i] = this.reMap[bytes2[i]];
        }
    }

    private int[] simplestCode(byte[] bytes2, int inputLength) {
        int i;
        int[] codes = new int[]{0, 0};
        codes[0] = Math.max(inputLength, 1) << 25;
        codes[1] = 0;
        for (i = 0; i < 3 && i < inputLength; ++i) {
            codes[0] = codes[0] | bytes2[i] << (2 - i) * 8;
        }
        for (i = 3; i < 7 && i < inputLength; ++i) {
            codes[1] = codes[1] | bytes2[i] << (6 - i) * 8;
        }
        return codes;
    }

    private int getCode(byte[] bytes2, int inputLength, int order) {
        long code = 0L;
        int size2 = inputLength;
        for (int i = 0; i < size2; ++i) {
            long val = bytes2[i * order % size2];
            for (int k = 1; k <= i; ++k) {
                long prev = val;
                val = (val << 4) + prev;
            }
            code += val;
        }
        return (int)code;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.numCodes + "]";
    }
}

