/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalUtil;

public abstract class ValueType {
    private static final Map<Class<?>, ValueType> byClass = new HashMap();
    private static final Map<Byte, ValueType> byId = new HashMap<Byte, ValueType>();
    private static ValueType stringType;
    private static byte next;
    private static final ValueType arrayType;
    private final Class<?>[] classes;
    private final byte id;

    private ValueType(Class<?> ... classes) {
        byte by2 = next;
        next = (byte)(by2 + 1);
        this.id = by2;
        this.classes = classes;
    }

    private static void add(ValueType type) {
        for (Class<?> cls : type.classes) {
            byClass.put(cls, type);
        }
        byId.put(type.id(), type);
    }

    public static ValueType typeOf(Object value2) {
        return ValueType.typeOf(value2.getClass());
    }

    public static ValueType typeOf(Class<?> cls) {
        if (cls.isArray()) {
            return arrayType;
        }
        ValueType type = byClass.get(cls);
        assert (type != null) : "Unrecognized value type " + cls;
        return type;
    }

    public static ValueType typeOf(byte id2) {
        if (id2 == arrayType.id()) {
            return arrayType;
        }
        ValueType type = byId.get(id2);
        assert (type != null) : "Unrecognized value type id " + id2;
        return type;
    }

    public static ValueType stringType() {
        return stringType;
    }

    private Class<?> componentClass() {
        return this.classes[0];
    }

    public final byte id() {
        return this.id;
    }

    public abstract Object read(ReadableClosableChannel var1) throws IOException;

    public abstract int length(Object var1);

    public abstract void write(Object var1, FlushableChannel var2) throws IOException;

    static {
        ValueType.add(new ValueType(new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return from2.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }

            @Override
            public int length(Object value2) {
                return 1;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.put((Boolean)value2 != false ? (byte)1 : 0);
            }
        });
        ValueType.add(new ValueType(new Class[]{Byte.TYPE, Byte.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return from2.get();
            }

            @Override
            public int length(Object value2) {
                return 1;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.put((Byte)value2);
            }
        });
        ValueType.add(new ValueType(new Class[]{Short.TYPE, Short.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return from2.getShort();
            }

            @Override
            public int length(Object value2) {
                return 2;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putShort((Short)value2);
            }
        });
        ValueType.add(new ValueType(new Class[]{Character.TYPE, Character.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return Character.valueOf((char)from2.getInt());
            }

            @Override
            public int length(Object value2) {
                return 2;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putInt(((Character)value2).charValue());
            }
        });
        ValueType.add(new ValueType(new Class[]{Integer.TYPE, Integer.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return from2.getInt();
            }

            @Override
            public int length(Object value2) {
                return 4;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putInt((Integer)value2);
            }
        });
        ValueType.add(new ValueType(new Class[]{Long.TYPE, Long.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return from2.getLong();
            }

            @Override
            public int length(Object value2) {
                return 8;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putLong((Long)value2);
            }
        });
        ValueType.add(new ValueType(new Class[]{Float.TYPE, Float.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return Float.valueOf(from2.getFloat());
            }

            @Override
            public int length(Object value2) {
                return 4;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putFloat(((Float)value2).floatValue());
            }
        });
        stringType = new ValueType(new Class[]{String.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                int length2 = from2.getInt();
                byte[] bytes2 = new byte[length2];
                from2.get(bytes2, length2);
                return UTF8.decode(bytes2);
            }

            @Override
            public int length(Object value2) {
                return 4 + UTF8.encode((String)value2).length * 2;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                byte[] bytes2 = UTF8.encode((String)value2);
                into.putInt(bytes2.length).put(bytes2, bytes2.length);
            }
        };
        ValueType.add(stringType);
        ValueType.add(new ValueType(new Class[]{Double.class, Double.TYPE}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return from2.getDouble();
            }

            @Override
            public int length(Object value2) {
                return 8;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putDouble((Double)value2);
            }
        });
        ValueType.add(new ValueType(new Class[]{LocalDate.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return LocalDate.ofEpochDay(from2.getLong());
            }

            @Override
            public int length(Object value2) {
                return 8;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putLong(((LocalDate)value2).toEpochDay());
            }
        });
        ValueType.add(new ValueType(new Class[]{LocalTime.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return LocalTime.ofNanoOfDay(from2.getLong());
            }

            @Override
            public int length(Object value2) {
                return 8;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                into.putLong(((LocalTime)value2).toNanoOfDay());
            }
        });
        ValueType.add(new ValueType(new Class[]{LocalDateTime.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return LocalDateTime.ofEpochSecond(from2.getLong(), from2.getInt(), ZoneOffset.UTC);
            }

            @Override
            public int length(Object value2) {
                return 12;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                LocalDateTime ldt = (LocalDateTime)value2;
                into.putLong(ldt.toEpochSecond(ZoneOffset.UTC));
                into.putInt(ldt.getNano());
            }
        });
        ValueType.add(new ValueType(new Class[]{OffsetTime.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                return OffsetTime.ofInstant(Instant.ofEpochSecond(0L, from2.getLong()), ZoneOffset.ofTotalSeconds(from2.getInt()));
            }

            @Override
            public int length(Object value2) {
                return 12;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                OffsetTime ot = (OffsetTime)value2;
                into.putLong(TemporalUtil.getNanosOfDayUTC(ot));
                into.putInt(ot.getOffset().getTotalSeconds());
            }
        });
        ValueType.add(new ValueType(new Class[]{ZonedDateTime.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                if (from2.get() == 0) {
                    long epochSecondsUTC = from2.getLong();
                    int nanos = from2.getInt();
                    int offsetSeconds = from2.getInt();
                    return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondsUTC, nanos), ZoneOffset.ofTotalSeconds(offsetSeconds));
                }
                long epochSecondsUTC = from2.getLong();
                int nanos = from2.getInt();
                int zoneID = from2.getInt();
                String zone = TimeZones.map((short)zoneID);
                return ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondsUTC, nanos), ZoneId.of(zone));
            }

            @Override
            public int length(Object value2) {
                return 17;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                ZonedDateTime zonedDateTime = (ZonedDateTime)value2;
                long epochSecondUTC = zonedDateTime.toEpochSecond();
                int nano = zonedDateTime.getNano();
                ZoneId zone = zonedDateTime.getZone();
                if (zone instanceof ZoneOffset) {
                    int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
                    into.put((byte)0);
                    into.putLong(epochSecondUTC);
                    into.putInt(nano);
                    into.putInt(offsetSeconds);
                } else {
                    String zoneId = zone.getId();
                    into.put((byte)1);
                    into.putLong(epochSecondUTC);
                    into.putInt(nano);
                    into.putInt(TimeZones.map(zoneId));
                }
            }
        });
        ValueType.add(new ValueType(new Class[]{DurationValue.class, Duration.class, Period.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                int nanos = from2.getInt();
                long seconds = from2.getLong();
                long days = from2.getLong();
                long months = from2.getLong();
                return DurationValue.duration(months, days, seconds, nanos);
            }

            @Override
            public int length(Object value2) {
                return 28;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                DurationValue duration = value2 instanceof Duration ? DurationValue.duration((Duration)value2) : (value2 instanceof Period ? DurationValue.duration((Period)value2) : (DurationValue)value2);
                into.putInt((int)duration.get(ChronoUnit.NANOS));
                into.putLong(duration.get(ChronoUnit.SECONDS));
                into.putLong(duration.get(ChronoUnit.DAYS));
                into.putLong(duration.get(ChronoUnit.MONTHS));
            }
        });
        ValueType.add(new ValueType(new Class[]{PointValue.class}){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                int code = from2.getInt();
                CoordinateReferenceSystem crs = CoordinateReferenceSystem.get(code);
                int length2 = from2.getInt();
                double[] coordinate = new double[length2];
                for (int i = 0; i < length2; ++i) {
                    coordinate[i] = from2.getDouble();
                }
                return Values.pointValue(crs, coordinate);
            }

            @Override
            public int length(Object value2) {
                return 8 + ((PointValue)value2).coordinate().length * 8;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                PointValue pointValue = (PointValue)value2;
                into.putInt(pointValue.getCoordinateReferenceSystem().getCode());
                double[] coordinate = pointValue.coordinate();
                into.putInt(coordinate.length);
                for (double c : coordinate) {
                    into.putDouble(c);
                }
            }
        });
        arrayType = new ValueType(new Class[0]){

            @Override
            public Object read(ReadableClosableChannel from2) throws IOException {
                ValueType componentType = 17.typeOf(from2.get());
                int length2 = from2.getInt();
                Object value2 = Array.newInstance(componentType.componentClass(), length2);
                for (int i = 0; i < length2; ++i) {
                    Array.set(value2, i, componentType.read(from2));
                }
                return value2;
            }

            @Override
            public int length(Object value2) {
                ValueType componentType = 17.typeOf(value2.getClass().getComponentType());
                int arrayLength = Array.getLength(value2);
                int length2 = 5;
                for (int i = 0; i < arrayLength; ++i) {
                    length2 += componentType.length(Array.get(value2, i));
                }
                return length2;
            }

            @Override
            public void write(Object value2, FlushableChannel into) throws IOException {
                ValueType componentType = 17.typeOf(value2.getClass().getComponentType());
                into.put(componentType.id());
                int length2 = Array.getLength(value2);
                into.putInt(length2);
                for (int i = 0; i < length2; ++i) {
                    componentType.write(Array.get(value2, i), into);
                }
            }
        };
    }
}

