/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Arrays;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;
import org.neo4j.values.storable.CSVHeaderInformation;

public class Header
implements Cloneable {
    private final Entry[] entries;

    public Header(Entry ... entries) {
        this.entries = entries;
    }

    public Entry[] entries() {
        return this.entries;
    }

    public String toString() {
        return Arrays.toString(this.entries);
    }

    public Header clone() {
        Entry[] entries = new Entry[this.entries.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = this.entries[i].clone();
        }
        return new Header(entries);
    }

    public static class Entry
    implements Cloneable {
        private final String name;
        private final Type type;
        private final Group group;
        private final Extractor<?> extractor;
        private final CSVHeaderInformation optionalParameter;

        public Entry(String name, Type type, Group group, Extractor<?> extractor) {
            this.name = name;
            this.type = type;
            this.group = group;
            this.extractor = extractor;
            this.optionalParameter = null;
        }

        public Entry(String name, Type type, Group group, Extractor<?> extractor, CSVHeaderInformation optionalParameter) {
            this.name = name;
            this.type = type;
            this.group = group;
            this.extractor = extractor;
            this.optionalParameter = optionalParameter;
        }

        public String toString() {
            if (this.optionalParameter == null) {
                return (this.name != null ? this.name : "") + ":" + (this.type == Type.PROPERTY ? this.extractor.name().toLowerCase() : this.type.name()) + (this.group() != Group.GLOBAL ? "(" + this.group().name() + ")" : "");
            }
            return (this.name != null ? this.name : "") + ":" + (this.type == Type.PROPERTY ? this.extractor.name().toLowerCase() + "[" + this.optionalParameter + "]" : this.type.name()) + (this.group() != Group.GLOBAL ? "(" + this.group().name() + ")" : "");
        }

        public Extractor<?> extractor() {
            return this.extractor;
        }

        public Type type() {
            return this.type;
        }

        public Group group() {
            return this.group != null ? this.group : Group.GLOBAL;
        }

        public String name() {
            return this.name;
        }

        public CSVHeaderInformation optionalParameter() {
            return this.optionalParameter;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            if (this.name != null) {
                result2 = 31 * result2 + this.name.hashCode();
            }
            result2 = 31 * result2 + this.type.hashCode();
            if (this.group != null) {
                result2 = 31 * result2 + this.group.hashCode();
            }
            result2 = 31 * result2 + this.extractor.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other2 = (Entry)obj;
            return this.nullSafeEquals(this.name, other2.name) && this.type == other2.type && this.nullSafeEquals(this.group, other2.group) && this.extractorEquals(this.extractor, other2.extractor) && this.nullSafeEquals(this.optionalParameter, other2.optionalParameter);
        }

        public Entry clone() {
            return new Entry(this.name, this.type, this.group, this.extractor != null ? this.extractor.clone() : null, this.optionalParameter);
        }

        private boolean nullSafeEquals(Object o1, Object o2) {
            return o1 == null || o2 == null ? o1 == o2 : o1.equals(o2);
        }

        private boolean extractorEquals(Extractor<?> first, Extractor<?> other2) {
            if (first == null || other2 == null) {
                return first == other2;
            }
            return first.getClass().equals(other2.getClass());
        }
    }

    public static interface Factory {
        public Header create(CharSeeker var1, Configuration var2, IdType var3, Groups var4);

        public boolean isDefined();
    }
}

