/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.hashing.HashFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class BooleanArray
extends ArrayValue {
    private final boolean[] value;

    BooleanArray(boolean[] value2) {
        assert (value2 != null);
        this.value = value2;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    public boolean booleanValue(int offset) {
        return this.value[offset];
    }

    @Override
    public String getTypeName() {
        return "BooleanArray";
    }

    @Override
    public boolean equals(Value other2) {
        return other2.equals(this.value);
    }

    @Override
    public boolean equals(boolean[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, this.value.length);
        hash = hashFunction.update(hash, this.hashCode());
        return hash;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapBooleanArray(this);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public boolean[] asObjectCopy() {
        return (boolean[])this.value.clone();
    }

    @Deprecated
    public boolean[] asObject() {
        return this.value;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return NumberValues.compareBooleanArrays(this, (BooleanArray)otherValue);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.BOOLEAN_ARRAY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int position2) {
        return Values.booleanValue(this.booleanValue(position2));
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }
}

