/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.hashing.HashFunction;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.ValueMath;

public abstract class FloatingPointValue
extends NumberValue {
    @Override
    public final boolean equals(long x) {
        return NumberValues.numbersEqual(this.doubleValue(), x);
    }

    @Override
    public final boolean equals(double x) {
        return this.doubleValue() == x;
    }

    @Override
    public final int computeHash() {
        return NumberValues.hash(this.doubleValue());
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return hashFunction.update(hash, Double.doubleToLongBits(this.doubleValue()));
    }

    @Override
    public boolean eq(Object other2) {
        return other2 instanceof Value && this.equals((Value)other2);
    }

    @Override
    public final boolean equals(Value other2) {
        if (other2 instanceof FloatingPointValue) {
            FloatingPointValue that = (FloatingPointValue)other2;
            return this.doubleValue() == that.doubleValue();
        }
        if (other2 instanceof IntegralValue) {
            IntegralValue that = (IntegralValue)other2;
            return NumberValues.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }

    @Override
    public NumberType numberType() {
        return NumberType.FLOATING_POINT;
    }

    @Override
    public int compareTo(IntegralValue other2) {
        return NumberValues.compareDoubleAgainstLong(this.doubleValue(), other2.longValue());
    }

    @Override
    public int compareTo(FloatingPointValue other2) {
        return Double.compare(this.doubleValue(), other2.doubleValue());
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.doubleValue());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public DoubleValue minus(long b) {
        return ValueMath.subtract(this.doubleValue(), (double)b);
    }

    @Override
    public DoubleValue minus(double b) {
        return ValueMath.subtract(this.doubleValue(), b);
    }

    @Override
    public DoubleValue plus(long b) {
        return ValueMath.add(this.doubleValue(), (double)b);
    }

    @Override
    public DoubleValue plus(double b) {
        return ValueMath.add(this.doubleValue(), b);
    }

    @Override
    public DoubleValue times(long b) {
        return ValueMath.multiply(this.doubleValue(), (double)b);
    }

    @Override
    public DoubleValue times(double b) {
        return ValueMath.multiply(this.doubleValue(), b);
    }

    @Override
    public DoubleValue dividedBy(long b) {
        return Values.doubleValue(this.doubleValue() / (double)b);
    }

    @Override
    public DoubleValue dividedBy(double b) {
        return Values.doubleValue(this.doubleValue() / b);
    }
}

