/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.math.BigDecimal;
import java.util.Arrays;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.IntegralArray;

public final class NumberValues {
    static final int MAX_LENGTH = 10000;
    private static final int[] COEFFICIENTS = new int[10001];
    private static final long NON_DOUBLE_LONG = -9007199254740992L;

    private NumberValues() {
    }

    public static int hash(long number) {
        int asInt = (int)number;
        if ((long)asInt == number) {
            return asInt;
        }
        return Long.hashCode(number);
    }

    public static int hash(double number) {
        long asLong = (long)number;
        if ((double)asLong == number) {
            return NumberValues.hash(asLong);
        }
        long bits2 = Double.doubleToLongBits(number);
        return (int)(bits2 ^ bits2 >>> 32);
    }

    public static int hash(byte[] values2) {
        int max2 = Math.min(values2.length, 10000);
        int result2 = COEFFICIENTS[max2];
        for (int i = 0; i < values2.length && i < COEFFICIENTS.length - 1; ++i) {
            result2 += COEFFICIENTS[max2 - i - 1] * values2[i];
        }
        return result2;
    }

    public static int hash(short[] values2) {
        int max2 = Math.min(values2.length, 10000);
        int result2 = COEFFICIENTS[max2];
        for (int i = 0; i < values2.length && i < COEFFICIENTS.length - 1; ++i) {
            result2 += COEFFICIENTS[max2 - i - 1] * values2[i];
        }
        return result2;
    }

    public static int hash(char[] values2) {
        int max2 = Math.min(values2.length, 10000);
        int result2 = COEFFICIENTS[max2];
        for (int i = 0; i < values2.length && i < COEFFICIENTS.length - 1; ++i) {
            result2 += COEFFICIENTS[max2 - i - 1] * values2[i];
        }
        return result2;
    }

    public static int hash(int[] values2) {
        int max2 = Math.min(values2.length, 10000);
        int result2 = COEFFICIENTS[max2];
        for (int i = 0; i < values2.length && i < COEFFICIENTS.length - 1; ++i) {
            result2 += COEFFICIENTS[max2 - i - 1] * values2[i];
        }
        return result2;
    }

    public static int hash(long[] values2) {
        int max2 = Math.min(values2.length, 10000);
        int result2 = COEFFICIENTS[max2];
        for (int i = 0; i < values2.length && i < COEFFICIENTS.length - 1; ++i) {
            result2 += COEFFICIENTS[max2 - i - 1] * NumberValues.hash(values2[i]);
        }
        return result2;
    }

    public static int hash(float[] values2) {
        int result2 = 1;
        for (float value2 : values2) {
            int elementHash = NumberValues.hash(value2);
            result2 = 31 * result2 + elementHash;
        }
        return result2;
    }

    public static int hash(double[] values2) {
        int result2 = 1;
        for (double value2 : values2) {
            int elementHash = NumberValues.hash(value2);
            result2 = 31 * result2 + elementHash;
        }
        return result2;
    }

    public static int hash(boolean[] value2) {
        return Arrays.hashCode(value2);
    }

    public static boolean numbersEqual(double fpn, long in2) {
        if (in2 < 0L) {
            if (fpn < 0.0) {
                if ((0xFFE0000000000000L & in2) == 0L) {
                    return fpn == (double)in2;
                }
                if (fpn < -9.223372036854776E18) {
                    return false;
                }
                if (fpn == Math.floor(fpn) && !Double.isInfinite(fpn)) {
                    return in2 == (long)fpn;
                }
            }
        } else if (!(fpn < 0.0)) {
            if ((0xFFE0000000000000L & in2) == 0L) {
                return fpn == (double)in2;
            }
            if (fpn > 9.223372036854776E18) {
                return false;
            }
            if (fpn == Math.floor(fpn) && !Double.isInfinite(fpn)) {
                return in2 == (long)fpn;
            }
        }
        return false;
    }

    public static int compareDoubleAgainstLong(double lhs, long rhs) {
        if ((0xFFE0000000000000L & rhs) != 0L) {
            if (Double.isNaN(lhs)) {
                return 1;
            }
            if (Double.isInfinite(lhs)) {
                return lhs < 0.0 ? -1 : 1;
            }
            return BigDecimal.valueOf(lhs).compareTo(BigDecimal.valueOf(rhs));
        }
        return Double.compare(lhs, rhs);
    }

    public static int compareLongAgainstDouble(long lhs, double rhs) {
        return -NumberValues.compareDoubleAgainstLong(rhs, lhs);
    }

    public static boolean numbersEqual(IntegralArray lhs, IntegralArray rhs) {
        int length2 = lhs.length();
        if (length2 != rhs.length()) {
            return false;
        }
        for (int i = 0; i < length2; ++i) {
            if (lhs.longValue(i) == rhs.longValue(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean numbersEqual(FloatingPointArray lhs, FloatingPointArray rhs) {
        int length2 = lhs.length();
        if (length2 != rhs.length()) {
            return false;
        }
        for (int i = 0; i < length2; ++i) {
            if (lhs.doubleValue(i) == rhs.doubleValue(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean numbersEqual(FloatingPointArray fps, IntegralArray ins) {
        int length2 = ins.length();
        if (length2 != fps.length()) {
            return false;
        }
        for (int i = 0; i < length2; ++i) {
            if (NumberValues.numbersEqual(fps.doubleValue(i), ins.longValue(i))) continue;
            return false;
        }
        return true;
    }

    public static int compareIntegerArrays(IntegralArray a, IntegralArray b) {
        int x = 0;
        int length2 = Math.min(a.length(), b.length());
        for (int i = 0; x == 0 && i < length2; ++i) {
            x = Long.compare(a.longValue(i), b.longValue(i));
        }
        if (x == 0) {
            x = a.length() - b.length();
        }
        return x;
    }

    public static int compareIntegerVsFloatArrays(IntegralArray a, FloatingPointArray b) {
        int x = 0;
        int length2 = Math.min(a.length(), b.length());
        for (int i = 0; x == 0 && i < length2; ++i) {
            x = NumberValues.compareLongAgainstDouble(a.longValue(i), b.doubleValue(i));
        }
        if (x == 0) {
            x = a.length() - b.length();
        }
        return x;
    }

    public static int compareFloatArrays(FloatingPointArray a, FloatingPointArray b) {
        int x = 0;
        int length2 = Math.min(a.length(), b.length());
        for (int i = 0; x == 0 && i < length2; ++i) {
            x = Double.compare(a.doubleValue(i), b.doubleValue(i));
        }
        if (x == 0) {
            x = a.length() - b.length();
        }
        return x;
    }

    public static int compareBooleanArrays(BooleanArray a, BooleanArray b) {
        int x = 0;
        int length2 = Math.min(a.length(), b.length());
        for (int i = 0; x == 0 && i < length2; ++i) {
            x = Boolean.compare(a.booleanValue(i), b.booleanValue(i));
        }
        if (x == 0) {
            x = a.length() - b.length();
        }
        return x;
    }

    static {
        NumberValues.COEFFICIENTS[0] = 1;
        for (int i = 1; i <= 10000; ++i) {
            NumberValues.COEFFICIENTS[i] = 31 * COEFFICIENTS[i - 1];
        }
    }
}

