/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.InvalidValuesArgumentException;

public enum PointFields {
    X("x"){

        @Override
        Value get(PointValue value2) {
            return value2.getNthCoordinate(0, this.propertyKey, false);
        }
    }
    ,
    Y("y"){

        @Override
        Value get(PointValue value2) {
            return value2.getNthCoordinate(1, this.propertyKey, false);
        }
    }
    ,
    Z("z"){

        @Override
        Value get(PointValue value2) {
            return value2.getNthCoordinate(2, this.propertyKey, false);
        }
    }
    ,
    LONGITUDE("longitude"){

        @Override
        Value get(PointValue value2) {
            return value2.getNthCoordinate(0, this.propertyKey, true);
        }
    }
    ,
    LATITUDE("latitude"){

        @Override
        Value get(PointValue value2) {
            return value2.getNthCoordinate(1, this.propertyKey, true);
        }
    }
    ,
    HEIGHT("height"){

        @Override
        Value get(PointValue value2) {
            return value2.getNthCoordinate(2, this.propertyKey, true);
        }
    }
    ,
    CRS("crs"){

        @Override
        Value get(PointValue value2) {
            return Values.stringValue(value2.getCoordinateReferenceSystem().toString());
        }
    }
    ,
    SRID("srid"){

        @Override
        Value get(PointValue value2) {
            return Values.intValue(value2.getCoordinateReferenceSystem().getCode());
        }
    };

    public String propertyKey;

    private PointFields(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public static PointFields fromName(String fieldName) {
        switch (fieldName.toLowerCase()) {
            case "x": {
                return X;
            }
            case "y": {
                return Y;
            }
            case "z": {
                return Z;
            }
            case "longitude": {
                return LONGITUDE;
            }
            case "latitude": {
                return LATITUDE;
            }
            case "height": {
                return HEIGHT;
            }
            case "crs": {
                return CRS;
            }
            case "srid": {
                return SRID;
            }
        }
        throw new InvalidValuesArgumentException("No such field: " + fieldName);
    }

    abstract Value get(PointValue var1);
}

