/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class PrimitiveArrayWriting {
    public static <E extends Exception> void writeTo(ValueWriter<E> writer, byte[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.BYTE);
        for (byte x : values2) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, short[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.SHORT);
        for (short x : values2) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, int[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.INT);
        for (int x : values2) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, long[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.LONG);
        for (long x : values2) {
            writer.writeInteger(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, float[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.FLOAT);
        for (float x : values2) {
            writer.writeFloatingPoint(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, double[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.DOUBLE);
        for (double x : values2) {
            writer.writeFloatingPoint(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, boolean[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.BOOLEAN);
        for (boolean x : values2) {
            writer.writeBoolean(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, char[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.CHAR);
        for (char x : values2) {
            writer.writeString(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, String[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.STRING);
        for (String x : values2) {
            writer.writeString(x);
        }
        writer.endArray();
    }

    public static <E extends Exception> void writeTo(ValueWriter<E> writer, Point[] values2) throws E {
        writer.beginArray(values2.length, ValueWriter.ArrayType.POINT);
        for (Point x : values2) {
            PointValue value2 = Values.point(x);
            writer.writePoint(value2.getCoordinateReferenceSystem(), value2.coordinate());
        }
        writer.endArray();
    }
}

